/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.utils.LazySingletonValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class ActionSearchDto {
    @JsonProperty(value="query")
    private String query;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="connector")
    private Optional<String> connector;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="top_k")
    private Optional<Double> topK;

    @JsonCreator
    public ActionSearchDto(@JsonProperty(value="query") String query, @JsonProperty(value="connector") Optional<String> connector, @JsonProperty(value="top_k") Optional<Double> topK) {
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(connector, "connector");
        Utils.checkNotNull(topK, "topK");
        this.query = query;
        this.connector = connector;
        this.topK = topK;
    }

    public ActionSearchDto(String query) {
        this(query, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String query() {
        return this.query;
    }

    @JsonIgnore
    public Optional<String> connector() {
        return this.connector;
    }

    @JsonIgnore
    public Optional<Double> topK() {
        return this.topK;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ActionSearchDto withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public ActionSearchDto withConnector(String connector) {
        Utils.checkNotNull(connector, "connector");
        this.connector = Optional.ofNullable(connector);
        return this;
    }

    public ActionSearchDto withConnector(Optional<String> connector) {
        Utils.checkNotNull(connector, "connector");
        this.connector = connector;
        return this;
    }

    public ActionSearchDto withTopK(double topK) {
        Utils.checkNotNull(topK, "topK");
        this.topK = Optional.ofNullable(topK);
        return this;
    }

    public ActionSearchDto withTopK(Optional<Double> topK) {
        Utils.checkNotNull(topK, "topK");
        this.topK = topK;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionSearchDto other = (ActionSearchDto)o;
        return Utils.enhancedDeepEquals(this.query, other.query) && Utils.enhancedDeepEquals(this.connector, other.connector) && Utils.enhancedDeepEquals(this.topK, other.topK);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.query, this.connector, this.topK);
    }

    public String toString() {
        return Utils.toString(ActionSearchDto.class, "query", this.query, "connector", this.connector, "topK", this.topK);
    }

    public static final class Builder {
        private String query;
        private Optional<String> connector = Optional.empty();
        private Optional<Double> topK;
        private static final LazySingletonValue<Optional<Double>> _SINGLETON_VALUE_TopK = new LazySingletonValue<Optional<Double>>("top_k", "100", new TypeReference<Optional<Double>>(){});

        private Builder() {
        }

        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public Builder connector(String connector) {
            Utils.checkNotNull(connector, "connector");
            this.connector = Optional.ofNullable(connector);
            return this;
        }

        public Builder connector(Optional<String> connector) {
            Utils.checkNotNull(connector, "connector");
            this.connector = connector;
            return this;
        }

        public Builder topK(double topK) {
            Utils.checkNotNull(topK, "topK");
            this.topK = Optional.ofNullable(topK);
            return this;
        }

        public Builder topK(Optional<Double> topK) {
            Utils.checkNotNull(topK, "topK");
            this.topK = topK;
            return this;
        }

        public ActionSearchDto build() {
            if (this.topK == null) {
                this.topK = _SINGLETON_VALUE_TopK.value();
            }
            return new ActionSearchDto(this.query, this.connector, this.topK);
        }
    }
}

