/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EmploymentDivisionValue {
    public static final EmploymentDivisionValue WORKSPACE = new EmploymentDivisionValue("workspace");
    public static final EmploymentDivisionValue TEAM = new EmploymentDivisionValue("team");
    public static final EmploymentDivisionValue DEPARTMENT = new EmploymentDivisionValue("department");
    public static final EmploymentDivisionValue GROUP = new EmploymentDivisionValue("group");
    public static final EmploymentDivisionValue ORGANIZATION = new EmploymentDivisionValue("organization");
    public static final EmploymentDivisionValue UNMAPPED_VALUE = new EmploymentDivisionValue("unmapped_value");
    public static final EmploymentDivisionValue COST_CENTER = new EmploymentDivisionValue("cost_center");
    private static final Map<String, EmploymentDivisionValue> values = EmploymentDivisionValue.createValuesMap();
    private static final Map<String, EmploymentDivisionValueEnum> enums = EmploymentDivisionValue.createEnumsMap();
    private final String value;

    private EmploymentDivisionValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static EmploymentDivisionValue of(String value) {
        Class<EmploymentDivisionValue> clazz = EmploymentDivisionValue.class;
        synchronized (EmploymentDivisionValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmploymentDivisionValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<EmploymentDivisionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmploymentDivisionValue other = (EmploymentDivisionValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmploymentDivisionValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentDivisionValue[] values() {
        Class<EmploymentDivisionValue> clazz = EmploymentDivisionValue.class;
        synchronized (EmploymentDivisionValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmploymentDivisionValue[0]);
        }
    }

    private static final Map<String, EmploymentDivisionValue> createValuesMap() {
        LinkedHashMap<String, EmploymentDivisionValue> map = new LinkedHashMap<String, EmploymentDivisionValue>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, EmploymentDivisionValueEnum> createEnumsMap() {
        HashMap<String, EmploymentDivisionValueEnum> map = new HashMap<String, EmploymentDivisionValueEnum>();
        map.put("workspace", EmploymentDivisionValueEnum.WORKSPACE);
        map.put("team", EmploymentDivisionValueEnum.TEAM);
        map.put("department", EmploymentDivisionValueEnum.DEPARTMENT);
        map.put("group", EmploymentDivisionValueEnum.GROUP);
        map.put("organization", EmploymentDivisionValueEnum.ORGANIZATION);
        map.put("unmapped_value", EmploymentDivisionValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", EmploymentDivisionValueEnum.COST_CENTER);
        return map;
    }

    public static enum EmploymentDivisionValueEnum {
        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center");

        private final String value;

        private EmploymentDivisionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

