/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Event {
    public static final Event SCREENING_RESULTS_CREATED = new Event("screening.results.created");
    public static final Event SCREENING_RESULTS_UPDATED = new Event("screening.results.updated");
    public static final Event SCREENING_RESULTS_COMPLETED = new Event("screening.results.completed");
    public static final Event SCREENING_RESULTS_FAILED = new Event("screening.results.failed");
    public static final Event SCREENING_RESULTS_CANCELLED = new Event("screening.results.cancelled");
    private static final Map<String, Event> values = Event.createValuesMap();
    private static final Map<String, EventEnum> enums = Event.createEnumsMap();
    private final String value;

    private Event(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static Event of(String value) {
        Class<Event> clazz = Event.class;
        synchronized (Event.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new Event((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<EventEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "Event [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event[] values() {
        Class<Event> clazz = Event.class;
        synchronized (Event.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new Event[0]);
        }
    }

    private static final Map<String, Event> createValuesMap() {
        LinkedHashMap<String, Event> map = new LinkedHashMap<String, Event>();
        map.put("screening.results.created", SCREENING_RESULTS_CREATED);
        map.put("screening.results.updated", SCREENING_RESULTS_UPDATED);
        map.put("screening.results.completed", SCREENING_RESULTS_COMPLETED);
        map.put("screening.results.failed", SCREENING_RESULTS_FAILED);
        map.put("screening.results.cancelled", SCREENING_RESULTS_CANCELLED);
        return map;
    }

    private static final Map<String, EventEnum> createEnumsMap() {
        HashMap<String, EventEnum> map = new HashMap<String, EventEnum>();
        map.put("screening.results.created", EventEnum.SCREENING_RESULTS_CREATED);
        map.put("screening.results.updated", EventEnum.SCREENING_RESULTS_UPDATED);
        map.put("screening.results.completed", EventEnum.SCREENING_RESULTS_COMPLETED);
        map.put("screening.results.failed", EventEnum.SCREENING_RESULTS_FAILED);
        map.put("screening.results.cancelled", EventEnum.SCREENING_RESULTS_CANCELLED);
        return map;
    }

    public static enum EventEnum {
        SCREENING_RESULTS_CREATED("screening.results.created"),
        SCREENING_RESULTS_UPDATED("screening.results.updated"),
        SCREENING_RESULTS_COMPLETED("screening.results.completed"),
        SCREENING_RESULTS_FAILED("screening.results.failed"),
        SCREENING_RESULTS_CANCELLED("screening.results.cancelled");

        private final String value;

        private EventEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

