/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IamRoleValue {
    public static final IamRoleValue ADMIN = new IamRoleValue("admin");
    public static final IamRoleValue VIEWER = new IamRoleValue("viewer");
    public static final IamRoleValue EDITOR = new IamRoleValue("editor");
    public static final IamRoleValue BASIC = new IamRoleValue("basic");
    public static final IamRoleValue GUEST = new IamRoleValue("guest");
    public static final IamRoleValue UNASSIGNED = new IamRoleValue("unassigned");
    public static final IamRoleValue RESTRICTED = new IamRoleValue("restricted");
    public static final IamRoleValue UNMAPPED_VALUE = new IamRoleValue("unmapped_value");
    private static final Map<String, IamRoleValue> values = IamRoleValue.createValuesMap();
    private static final Map<String, IamRoleValueEnum> enums = IamRoleValue.createEnumsMap();
    private final String value;

    private IamRoleValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static IamRoleValue of(String value) {
        Class<IamRoleValue> clazz = IamRoleValue.class;
        synchronized (IamRoleValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new IamRoleValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<IamRoleValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IamRoleValue other = (IamRoleValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "IamRoleValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamRoleValue[] values() {
        Class<IamRoleValue> clazz = IamRoleValue.class;
        synchronized (IamRoleValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new IamRoleValue[0]);
        }
    }

    private static final Map<String, IamRoleValue> createValuesMap() {
        LinkedHashMap<String, IamRoleValue> map = new LinkedHashMap<String, IamRoleValue>();
        map.put("admin", ADMIN);
        map.put("viewer", VIEWER);
        map.put("editor", EDITOR);
        map.put("basic", BASIC);
        map.put("guest", GUEST);
        map.put("unassigned", UNASSIGNED);
        map.put("restricted", RESTRICTED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamRoleValueEnum> createEnumsMap() {
        HashMap<String, IamRoleValueEnum> map = new HashMap<String, IamRoleValueEnum>();
        map.put("admin", IamRoleValueEnum.ADMIN);
        map.put("viewer", IamRoleValueEnum.VIEWER);
        map.put("editor", IamRoleValueEnum.EDITOR);
        map.put("basic", IamRoleValueEnum.BASIC);
        map.put("guest", IamRoleValueEnum.GUEST);
        map.put("unassigned", IamRoleValueEnum.UNASSIGNED);
        map.put("restricted", IamRoleValueEnum.RESTRICTED);
        map.put("unmapped_value", IamRoleValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum IamRoleValueEnum {
        ADMIN("admin"),
        VIEWER("viewer"),
        EDITOR("editor"),
        BASIC("basic"),
        GUEST("guest"),
        UNASSIGNED("unassigned"),
        RESTRICTED("restricted"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private IamRoleValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

