/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JournalLineValue {
    public static final JournalLineValue ASSET = new JournalLineValue("asset");
    public static final JournalLineValue LIABILITY = new JournalLineValue("liability");
    public static final JournalLineValue EQUITY = new JournalLineValue("equity");
    public static final JournalLineValue REVENUE = new JournalLineValue("revenue");
    public static final JournalLineValue EXPENSE = new JournalLineValue("expense");
    public static final JournalLineValue UNMAPPED_VALUE = new JournalLineValue("unmapped_value");
    private static final Map<String, JournalLineValue> values = JournalLineValue.createValuesMap();
    private static final Map<String, JournalLineValueEnum> enums = JournalLineValue.createEnumsMap();
    private final String value;

    private JournalLineValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static JournalLineValue of(String value) {
        Class<JournalLineValue> clazz = JournalLineValue.class;
        synchronized (JournalLineValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new JournalLineValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<JournalLineValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JournalLineValue other = (JournalLineValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "JournalLineValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JournalLineValue[] values() {
        Class<JournalLineValue> clazz = JournalLineValue.class;
        synchronized (JournalLineValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new JournalLineValue[0]);
        }
    }

    private static final Map<String, JournalLineValue> createValuesMap() {
        LinkedHashMap<String, JournalLineValue> map = new LinkedHashMap<String, JournalLineValue>();
        map.put("asset", ASSET);
        map.put("liability", LIABILITY);
        map.put("equity", EQUITY);
        map.put("revenue", REVENUE);
        map.put("expense", EXPENSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, JournalLineValueEnum> createEnumsMap() {
        HashMap<String, JournalLineValueEnum> map = new HashMap<String, JournalLineValueEnum>();
        map.put("asset", JournalLineValueEnum.ASSET);
        map.put("liability", JournalLineValueEnum.LIABILITY);
        map.put("equity", JournalLineValueEnum.EQUITY);
        map.put("revenue", JournalLineValueEnum.REVENUE);
        map.put("expense", JournalLineValueEnum.EXPENSE);
        map.put("unmapped_value", JournalLineValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum JournalLineValueEnum {
        ASSET("asset"),
        LIABILITY("liability"),
        EQUITY("equity"),
        REVENUE("revenue"),
        EXPENSE("expense"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private JournalLineValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

