/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NoteValue {
    public static final NoteValue PRIVATE = new NoteValue("private");
    public static final NoteValue PUBLIC = new NoteValue("public");
    public static final NoteValue UNMAPPED_VALUE = new NoteValue("unmapped_value");
    private static final Map<String, NoteValue> values = NoteValue.createValuesMap();
    private static final Map<String, NoteValueEnum> enums = NoteValue.createEnumsMap();
    private final String value;

    private NoteValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static NoteValue of(String value) {
        Class<NoteValue> clazz = NoteValue.class;
        synchronized (NoteValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new NoteValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<NoteValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NoteValue other = (NoteValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "NoteValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NoteValue[] values() {
        Class<NoteValue> clazz = NoteValue.class;
        synchronized (NoteValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new NoteValue[0]);
        }
    }

    private static final Map<String, NoteValue> createValuesMap() {
        LinkedHashMap<String, NoteValue> map = new LinkedHashMap<String, NoteValue>();
        map.put("private", PRIVATE);
        map.put("public", PUBLIC);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, NoteValueEnum> createEnumsMap() {
        HashMap<String, NoteValueEnum> map = new HashMap<String, NoteValueEnum>();
        map.put("private", NoteValueEnum.PRIVATE);
        map.put("public", NoteValueEnum.PUBLIC);
        map.put("unmapped_value", NoteValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum NoteValueEnum {
        PRIVATE("private"),
        PUBLIC("public"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private NoteValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

