/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TicketingTicketResultDataValue {
    public static final TicketingTicketResultDataValue TO_DO = new TicketingTicketResultDataValue("to-do");
    public static final TicketingTicketResultDataValue IN_PROGRESS = new TicketingTicketResultDataValue("in-progress");
    public static final TicketingTicketResultDataValue CLOSED = new TicketingTicketResultDataValue("closed");
    public static final TicketingTicketResultDataValue UNMAPPED_VALUE = new TicketingTicketResultDataValue("unmapped_value");
    private static final Map<String, TicketingTicketResultDataValue> values = TicketingTicketResultDataValue.createValuesMap();
    private static final Map<String, TicketingTicketResultDataValueEnum> enums = TicketingTicketResultDataValue.createEnumsMap();
    private final String value;

    private TicketingTicketResultDataValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static TicketingTicketResultDataValue of(String value) {
        Class<TicketingTicketResultDataValue> clazz = TicketingTicketResultDataValue.class;
        synchronized (TicketingTicketResultDataValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TicketingTicketResultDataValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TicketingTicketResultDataValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketingTicketResultDataValue other = (TicketingTicketResultDataValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TicketingTicketResultDataValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TicketingTicketResultDataValue[] values() {
        Class<TicketingTicketResultDataValue> clazz = TicketingTicketResultDataValue.class;
        synchronized (TicketingTicketResultDataValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TicketingTicketResultDataValue[0]);
        }
    }

    private static final Map<String, TicketingTicketResultDataValue> createValuesMap() {
        LinkedHashMap<String, TicketingTicketResultDataValue> map = new LinkedHashMap<String, TicketingTicketResultDataValue>();
        map.put("to-do", TO_DO);
        map.put("in-progress", IN_PROGRESS);
        map.put("closed", CLOSED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TicketingTicketResultDataValueEnum> createEnumsMap() {
        HashMap<String, TicketingTicketResultDataValueEnum> map = new HashMap<String, TicketingTicketResultDataValueEnum>();
        map.put("to-do", TicketingTicketResultDataValueEnum.TO_DO);
        map.put("in-progress", TicketingTicketResultDataValueEnum.IN_PROGRESS);
        map.put("closed", TicketingTicketResultDataValueEnum.CLOSED);
        map.put("unmapped_value", TicketingTicketResultDataValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TicketingTicketResultDataValueEnum {
        TO_DO("to-do"),
        IN_PROGRESS("in-progress"),
        CLOSED("closed"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TicketingTicketResultDataValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

