/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamUpdateUserRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class IamUpdateUserRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private IamUpdateUserRequestDto iamUpdateUserRequestDto;

    @JsonCreator
    public IamUpdateUserRequest(String xAccountId, String id, Optional<String> prefer, IamUpdateUserRequestDto iamUpdateUserRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(iamUpdateUserRequestDto, "iamUpdateUserRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.iamUpdateUserRequestDto = iamUpdateUserRequestDto;
    }

    public IamUpdateUserRequest(String xAccountId, String id, IamUpdateUserRequestDto iamUpdateUserRequestDto) {
        this(xAccountId, id, Optional.empty(), iamUpdateUserRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public IamUpdateUserRequestDto iamUpdateUserRequestDto() {
        return this.iamUpdateUserRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public IamUpdateUserRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public IamUpdateUserRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public IamUpdateUserRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public IamUpdateUserRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public IamUpdateUserRequest withIamUpdateUserRequestDto(IamUpdateUserRequestDto iamUpdateUserRequestDto) {
        Utils.checkNotNull(iamUpdateUserRequestDto, "iamUpdateUserRequestDto");
        this.iamUpdateUserRequestDto = iamUpdateUserRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamUpdateUserRequest other = (IamUpdateUserRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.iamUpdateUserRequestDto, other.iamUpdateUserRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.iamUpdateUserRequestDto);
    }

    public String toString() {
        return Utils.toString(IamUpdateUserRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "iamUpdateUserRequestDto", this.iamUpdateUserRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private IamUpdateUserRequestDto iamUpdateUserRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder iamUpdateUserRequestDto(IamUpdateUserRequestDto iamUpdateUserRequestDto) {
            Utils.checkNotNull(iamUpdateUserRequestDto, "iamUpdateUserRequestDto");
            this.iamUpdateUserRequestDto = iamUpdateUserRequestDto;
            return this;
        }

        public IamUpdateUserRequest build() {
            return new IamUpdateUserRequest(this.xAccountId, this.id, this.prefer, this.iamUpdateUserRequestDto);
        }
    }
}

