/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * CampaignValue - The schedule type of the campaign.
 */
@JsonDeserialize(using = CampaignValue._Deserializer.class)
@JsonSerialize(using = CampaignValue._Serializer.class)
public class CampaignValue {

    public static final CampaignValue IMMEDIATE = new CampaignValue("immediate");
    public static final CampaignValue SCHEDULED = new CampaignValue("scheduled");
    public static final CampaignValue RECURRING = new CampaignValue("recurring");
    public static final CampaignValue CUSTOM = new CampaignValue("custom");
    public static final CampaignValue TRIGGERED = new CampaignValue("triggered");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CampaignValue> values = createValuesMap();
    private static final Map<String, CampaignValueEnum> enums = createEnumsMap();

    private final String value;

    private CampaignValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CampaignValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CampaignValue
     */ 
    public static CampaignValue of(String value) {
        synchronized (CampaignValue.class) {
            return values.computeIfAbsent(value, v -> new CampaignValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<CampaignValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CampaignValue other = (CampaignValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CampaignValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CampaignValue[] values() {
        synchronized (CampaignValue.class) {
            return values.values().toArray(new CampaignValue[] {});
        }
    }

    private static final Map<String, CampaignValue> createValuesMap() {
        Map<String, CampaignValue> map = new LinkedHashMap<>();
        map.put("immediate", IMMEDIATE);
        map.put("scheduled", SCHEDULED);
        map.put("recurring", RECURRING);
        map.put("custom", CUSTOM);
        map.put("triggered", TRIGGERED);
        return map;
    }

    private static final Map<String, CampaignValueEnum> createEnumsMap() {
        Map<String, CampaignValueEnum> map = new HashMap<>();
        map.put("immediate", CampaignValueEnum.IMMEDIATE);
        map.put("scheduled", CampaignValueEnum.SCHEDULED);
        map.put("recurring", CampaignValueEnum.RECURRING);
        map.put("custom", CampaignValueEnum.CUSTOM);
        map.put("triggered", CampaignValueEnum.TRIGGERED);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<CampaignValue> {

        protected _Serializer() {
            super(CampaignValue.class);
        }

        @Override
        public void serialize(CampaignValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<CampaignValue> {

        protected _Deserializer() {
            super(CampaignValue.class);
        }

        @Override
        public CampaignValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return CampaignValue.of(v);
        }
    }
    
    public enum CampaignValueEnum {

        IMMEDIATE("immediate"),
        SCHEDULED("scheduled"),
        RECURRING("recurring"),
        CUSTOM("custom"),
        TRIGGERED("triggered"),;

        private final String value;

        private CampaignValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
