/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsRejectApplicationRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class AtsRejectApplicationRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsRejectApplicationRequestDto atsRejectApplicationRequestDto;

    @JsonCreator
    public AtsRejectApplicationRequest(String xAccountId, String id, AtsRejectApplicationRequestDto atsRejectApplicationRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(atsRejectApplicationRequestDto, "atsRejectApplicationRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.atsRejectApplicationRequestDto = atsRejectApplicationRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public AtsRejectApplicationRequestDto atsRejectApplicationRequestDto() {
        return this.atsRejectApplicationRequestDto;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsRejectApplicationRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsRejectApplicationRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsRejectApplicationRequest withAtsRejectApplicationRequestDto(AtsRejectApplicationRequestDto atsRejectApplicationRequestDto) {
        Utils.checkNotNull(atsRejectApplicationRequestDto, "atsRejectApplicationRequestDto");
        this.atsRejectApplicationRequestDto = atsRejectApplicationRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsRejectApplicationRequest other = (AtsRejectApplicationRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.atsRejectApplicationRequestDto, other.atsRejectApplicationRequestDto);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.id, this.atsRejectApplicationRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsRejectApplicationRequest.class, "xAccountId", this.xAccountId, "id", this.id, "atsRejectApplicationRequestDto", this.atsRejectApplicationRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private AtsRejectApplicationRequestDto atsRejectApplicationRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder atsRejectApplicationRequestDto(AtsRejectApplicationRequestDto atsRejectApplicationRequestDto) {
            Utils.checkNotNull(atsRejectApplicationRequestDto, "atsRejectApplicationRequestDto");
            this.atsRejectApplicationRequestDto = atsRejectApplicationRequestDto;
            return this;
        }

        public AtsRejectApplicationRequest build() {
            return new AtsRejectApplicationRequest(this.xAccountId, this.id, this.atsRejectApplicationRequestDto);
        }
    }
}

