/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class BackgroundCheckOrderApplicationStatus {

    /**
     * The status of the application.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends BackgroundCheckOrderValue> value;

    /**
     * The source value of the application status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends BackgroundCheckOrderSourceValue> sourceValue;

    @JsonCreator
    public BackgroundCheckOrderApplicationStatus(
            @JsonProperty("value") JsonNullable<? extends BackgroundCheckOrderValue> value,
            @JsonProperty("source_value") JsonNullable<? extends BackgroundCheckOrderSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public BackgroundCheckOrderApplicationStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The status of the application.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<BackgroundCheckOrderValue> value() {
        return (JsonNullable<BackgroundCheckOrderValue>) value;
    }

    /**
     * The source value of the application status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<BackgroundCheckOrderSourceValue> sourceValue() {
        return (JsonNullable<BackgroundCheckOrderSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The status of the application.
     */
    public BackgroundCheckOrderApplicationStatus withValue(BackgroundCheckOrderValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The status of the application.
     */
    public BackgroundCheckOrderApplicationStatus withValue(JsonNullable<? extends BackgroundCheckOrderValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the application status.
     */
    public BackgroundCheckOrderApplicationStatus withSourceValue(BackgroundCheckOrderSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the application status.
     */
    public BackgroundCheckOrderApplicationStatus withSourceValue(JsonNullable<? extends BackgroundCheckOrderSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BackgroundCheckOrderApplicationStatus other = (BackgroundCheckOrderApplicationStatus) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BackgroundCheckOrderApplicationStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends BackgroundCheckOrderValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends BackgroundCheckOrderSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The status of the application.
         */
        public Builder value(BackgroundCheckOrderValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The status of the application.
         */
        public Builder value(JsonNullable<? extends BackgroundCheckOrderValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the application status.
         */
        public Builder sourceValue(BackgroundCheckOrderSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the application status.
         */
        public Builder sourceValue(JsonNullable<? extends BackgroundCheckOrderSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public BackgroundCheckOrderApplicationStatus build() {
            return new BackgroundCheckOrderApplicationStatus(
                value,
                sourceValue);
        }
    }
}
