/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Images
 * 
 * <p>Image assets for this provider
 */
public class Images {

    /**
     * URL of the square logo designed and used by StackOne for this provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("logo_url")
    private JsonNullable<String> logoUrl;

    /**
     * URL of the original provider logo (with logo and/or name aligned horizontally)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("original_logo_horizontal_url")
    private JsonNullable<String> originalLogoHorizontalUrl;

    @JsonCreator
    public Images(
            @JsonProperty("logo_url") JsonNullable<String> logoUrl,
            @JsonProperty("original_logo_horizontal_url") JsonNullable<String> originalLogoHorizontalUrl) {
        Utils.checkNotNull(logoUrl, "logoUrl");
        Utils.checkNotNull(originalLogoHorizontalUrl, "originalLogoHorizontalUrl");
        this.logoUrl = logoUrl;
        this.originalLogoHorizontalUrl = originalLogoHorizontalUrl;
    }
    
    public Images() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * URL of the square logo designed and used by StackOne for this provider
     */
    @JsonIgnore
    public JsonNullable<String> logoUrl() {
        return logoUrl;
    }

    /**
     * URL of the original provider logo (with logo and/or name aligned horizontally)
     */
    @JsonIgnore
    public JsonNullable<String> originalLogoHorizontalUrl() {
        return originalLogoHorizontalUrl;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * URL of the square logo designed and used by StackOne for this provider
     */
    public Images withLogoUrl(String logoUrl) {
        Utils.checkNotNull(logoUrl, "logoUrl");
        this.logoUrl = JsonNullable.of(logoUrl);
        return this;
    }

    /**
     * URL of the square logo designed and used by StackOne for this provider
     */
    public Images withLogoUrl(JsonNullable<String> logoUrl) {
        Utils.checkNotNull(logoUrl, "logoUrl");
        this.logoUrl = logoUrl;
        return this;
    }

    /**
     * URL of the original provider logo (with logo and/or name aligned horizontally)
     */
    public Images withOriginalLogoHorizontalUrl(String originalLogoHorizontalUrl) {
        Utils.checkNotNull(originalLogoHorizontalUrl, "originalLogoHorizontalUrl");
        this.originalLogoHorizontalUrl = JsonNullable.of(originalLogoHorizontalUrl);
        return this;
    }

    /**
     * URL of the original provider logo (with logo and/or name aligned horizontally)
     */
    public Images withOriginalLogoHorizontalUrl(JsonNullable<String> originalLogoHorizontalUrl) {
        Utils.checkNotNull(originalLogoHorizontalUrl, "originalLogoHorizontalUrl");
        this.originalLogoHorizontalUrl = originalLogoHorizontalUrl;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Images other = (Images) o;
        return 
            Objects.deepEquals(this.logoUrl, other.logoUrl) &&
            Objects.deepEquals(this.originalLogoHorizontalUrl, other.originalLogoHorizontalUrl);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            logoUrl,
            originalLogoHorizontalUrl);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Images.class,
                "logoUrl", logoUrl,
                "originalLogoHorizontalUrl", originalLogoHorizontalUrl);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> logoUrl = JsonNullable.undefined();
 
        private JsonNullable<String> originalLogoHorizontalUrl = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * URL of the square logo designed and used by StackOne for this provider
         */
        public Builder logoUrl(String logoUrl) {
            Utils.checkNotNull(logoUrl, "logoUrl");
            this.logoUrl = JsonNullable.of(logoUrl);
            return this;
        }

        /**
         * URL of the square logo designed and used by StackOne for this provider
         */
        public Builder logoUrl(JsonNullable<String> logoUrl) {
            Utils.checkNotNull(logoUrl, "logoUrl");
            this.logoUrl = logoUrl;
            return this;
        }

        /**
         * URL of the original provider logo (with logo and/or name aligned horizontally)
         */
        public Builder originalLogoHorizontalUrl(String originalLogoHorizontalUrl) {
            Utils.checkNotNull(originalLogoHorizontalUrl, "originalLogoHorizontalUrl");
            this.originalLogoHorizontalUrl = JsonNullable.of(originalLogoHorizontalUrl);
            return this;
        }

        /**
         * URL of the original provider logo (with logo and/or name aligned horizontally)
         */
        public Builder originalLogoHorizontalUrl(JsonNullable<String> originalLogoHorizontalUrl) {
            Utils.checkNotNull(originalLogoHorizontalUrl, "originalLogoHorizontalUrl");
            this.originalLogoHorizontalUrl = originalLogoHorizontalUrl;
            return this;
        }
        
        public Images build() {
            return new Images(
                logoUrl,
                originalLogoHorizontalUrl);
        }
    }
}
