/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * Method
 * 
 * <p>The method of the request
 */
@JsonDeserialize(using = Method._Deserializer.class)
@JsonSerialize(using = Method._Serializer.class)
public class Method {

    public static final Method GET = new Method("get");
    public static final Method POST = new Method("post");
    public static final Method PUT = new Method("put");
    public static final Method DELETE = new Method("delete");
    public static final Method PATCH = new Method("patch");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, Method> values = createValuesMap();
    private static final Map<String, MethodEnum> enums = createEnumsMap();

    private final String value;

    private Method(String value) {
        this.value = value;
    }

    /**
     * Returns a Method with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as Method
     */ 
    public static Method of(String value) {
        synchronized (Method.class) {
            return values.computeIfAbsent(value, v -> new Method(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<MethodEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Method other = (Method) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "Method [value=" + value + "]";
    }

    // return an array just like an enum
    public static Method[] values() {
        synchronized (Method.class) {
            return values.values().toArray(new Method[] {});
        }
    }

    private static final Map<String, Method> createValuesMap() {
        Map<String, Method> map = new LinkedHashMap<>();
        map.put("get", GET);
        map.put("post", POST);
        map.put("put", PUT);
        map.put("delete", DELETE);
        map.put("patch", PATCH);
        return map;
    }

    private static final Map<String, MethodEnum> createEnumsMap() {
        Map<String, MethodEnum> map = new HashMap<>();
        map.put("get", MethodEnum.GET);
        map.put("post", MethodEnum.POST);
        map.put("put", MethodEnum.PUT);
        map.put("delete", MethodEnum.DELETE);
        map.put("patch", MethodEnum.PATCH);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<Method> {

        protected _Serializer() {
            super(Method.class);
        }

        @Override
        public void serialize(Method value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<Method> {

        protected _Deserializer() {
            super(Method.class);
        }

        @Override
        public Method deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return Method.of(v);
        }
    }
    
    public enum MethodEnum {

        GET("get"),
        POST("post"),
        PUT("put"),
        DELETE("delete"),
        PATCH("patch"),;

        private final String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

