/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.OffersPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Deprecated;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class AtsListApplicationsOffersResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The offers related to the application with the given identifier were retrieved.
     */
    private Optional<? extends OffersPaginated> offersPaginated;

    private Map<String, List<String>> headers;

    private Callable<Optional<AtsListApplicationsOffersResponse>> next = () -> Optional.empty();

    @JsonCreator
    public AtsListApplicationsOffersResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends OffersPaginated> offersPaginated,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(offersPaginated, "offersPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.offersPaginated = offersPaginated;
        this.headers = headers;
    }
    
    public AtsListApplicationsOffersResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The offers related to the application with the given identifier were retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<OffersPaginated> offersPaginated() {
        return (Optional<OffersPaginated>) offersPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public Optional<AtsListApplicationsOffersResponse> next() throws Exception {
        return this.next.call();
    }
    
    // internal use only
    private AtsListApplicationsOffersResponse withNext(Callable<Optional<AtsListApplicationsOffersResponse>> next) {
        this.next = next;
        return this;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * HTTP response content type for this operation
     */
    public AtsListApplicationsOffersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public AtsListApplicationsOffersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public AtsListApplicationsOffersResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The offers related to the application with the given identifier were retrieved.
     */
    public AtsListApplicationsOffersResponse withOffersPaginated(OffersPaginated offersPaginated) {
        Utils.checkNotNull(offersPaginated, "offersPaginated");
        this.offersPaginated = Optional.ofNullable(offersPaginated);
        return this;
    }

    /**
     * The offers related to the application with the given identifier were retrieved.
     */
    public AtsListApplicationsOffersResponse withOffersPaginated(Optional<? extends OffersPaginated> offersPaginated) {
        Utils.checkNotNull(offersPaginated, "offersPaginated");
        this.offersPaginated = offersPaginated;
        return this;
    }

    public AtsListApplicationsOffersResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsListApplicationsOffersResponse other = (AtsListApplicationsOffersResponse) o;
        return 
            Objects.deepEquals(this.contentType, other.contentType) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.rawResponse, other.rawResponse) &&
            Objects.deepEquals(this.offersPaginated, other.offersPaginated) &&
            Objects.deepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            contentType,
            statusCode,
            rawResponse,
            offersPaginated,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsListApplicationsOffersResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "offersPaginated", offersPaginated,
                "headers", headers);
    }
    
    public final static class Builder {
        private Callable<Optional<AtsListApplicationsOffersResponse>> next;
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends OffersPaginated> offersPaginated = Optional.empty();
 
        private Map<String, List<String>> headers;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The offers related to the application with the given identifier were retrieved.
         */
        public Builder offersPaginated(OffersPaginated offersPaginated) {
            Utils.checkNotNull(offersPaginated, "offersPaginated");
            this.offersPaginated = Optional.ofNullable(offersPaginated);
            return this;
        }

        /**
         * The offers related to the application with the given identifier were retrieved.
         */
        public Builder offersPaginated(Optional<? extends OffersPaginated> offersPaginated) {
            Utils.checkNotNull(offersPaginated, "offersPaginated");
            this.offersPaginated = offersPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        /**
         * Internal API. Not for public use. Sets the provider of the next page.
         *
         * @deprecated not part of the public API, may be removed without notice
         */
        @Deprecated
        public Builder next(Callable<Optional<AtsListApplicationsOffersResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }
        
        public AtsListApplicationsOffersResponse build() {
            return new AtsListApplicationsOffersResponse(
                contentType,
                statusCode,
                rawResponse,
                offersPaginated,
                headers)
                .withNext(next);
        }
    }
}
