/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreateContentBlocksRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MarketingUpdateContentBlockRequest {

    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    @SpeakeasyMetadata("request:mediaType=application/json")
    private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;

    @JsonCreator
    public MarketingUpdateContentBlockRequest(
            String xAccountId,
            String id,
            MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto() {
        return marketingCreateContentBlocksRequestDto;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The account identifier
     */
    public MarketingUpdateContentBlockRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MarketingUpdateContentBlockRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public MarketingUpdateContentBlockRequest withMarketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MarketingUpdateContentBlockRequest other = (MarketingUpdateContentBlockRequest) o;
        return 
            Objects.deepEquals(this.xAccountId, other.xAccountId) &&
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.marketingCreateContentBlocksRequestDto, other.marketingCreateContentBlocksRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xAccountId,
            id,
            marketingCreateContentBlocksRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MarketingUpdateContentBlockRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "marketingCreateContentBlocksRequestDto", marketingCreateContentBlocksRequestDto);
    }
    
    public final static class Builder {
 
        private String xAccountId;
 
        private String id;
 
        private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder marketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
            Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
            this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
            return this;
        }
        
        public MarketingUpdateContentBlockRequest build() {
            return new MarketingUpdateContentBlockRequest(
                xAccountId,
                id,
                marketingCreateContentBlocksRequestDto);
        }
    }
}
