/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneListStepLogsRequest {

    /**
     * The field to order the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=order_by")
    private JsonNullable<? extends OrderBy> orderBy;

    /**
     * The direction to order the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=order_direction")
    private JsonNullable<? extends OrderDirection> orderDirection;

    /**
     * The number of results per page (default value is 25)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=page_size")
    private JsonNullable<Double> pageSize;

    /**
     * The unified cursor
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=next")
    private JsonNullable<String> next;

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=filter")
    private JsonNullable<? extends Filter> filter;

    @JsonCreator
    public StackoneListStepLogsRequest(
            JsonNullable<? extends OrderBy> orderBy,
            JsonNullable<? extends OrderDirection> orderDirection,
            JsonNullable<Double> pageSize,
            JsonNullable<String> next,
            JsonNullable<? extends Filter> filter) {
        Utils.checkNotNull(orderBy, "orderBy");
        Utils.checkNotNull(orderDirection, "orderDirection");
        Utils.checkNotNull(pageSize, "pageSize");
        Utils.checkNotNull(next, "next");
        Utils.checkNotNull(filter, "filter");
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
        this.pageSize = pageSize;
        this.next = next;
        this.filter = filter;
    }
    
    public StackoneListStepLogsRequest() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The field to order the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<OrderBy> orderBy() {
        return (JsonNullable<OrderBy>) orderBy;
    }

    /**
     * The direction to order the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<OrderDirection> orderDirection() {
        return (JsonNullable<OrderDirection>) orderDirection;
    }

    /**
     * The number of results per page (default value is 25)
     */
    @JsonIgnore
    public JsonNullable<Double> pageSize() {
        return pageSize;
    }

    /**
     * The unified cursor
     */
    @JsonIgnore
    public JsonNullable<String> next() {
        return next;
    }

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Filter> filter() {
        return (JsonNullable<Filter>) filter;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The field to order the results by.
     */
    public StackoneListStepLogsRequest withOrderBy(OrderBy orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = JsonNullable.of(orderBy);
        return this;
    }

    /**
     * The field to order the results by.
     */
    public StackoneListStepLogsRequest withOrderBy(JsonNullable<? extends OrderBy> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    /**
     * The direction to order the results by.
     */
    public StackoneListStepLogsRequest withOrderDirection(OrderDirection orderDirection) {
        Utils.checkNotNull(orderDirection, "orderDirection");
        this.orderDirection = JsonNullable.of(orderDirection);
        return this;
    }

    /**
     * The direction to order the results by.
     */
    public StackoneListStepLogsRequest withOrderDirection(JsonNullable<? extends OrderDirection> orderDirection) {
        Utils.checkNotNull(orderDirection, "orderDirection");
        this.orderDirection = orderDirection;
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public StackoneListStepLogsRequest withPageSize(double pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = JsonNullable.of(pageSize);
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public StackoneListStepLogsRequest withPageSize(JsonNullable<Double> pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = pageSize;
        return this;
    }

    /**
     * The unified cursor
     */
    public StackoneListStepLogsRequest withNext(String next) {
        Utils.checkNotNull(next, "next");
        this.next = JsonNullable.of(next);
        return this;
    }

    /**
     * The unified cursor
     */
    public StackoneListStepLogsRequest withNext(JsonNullable<String> next) {
        Utils.checkNotNull(next, "next");
        this.next = next;
        return this;
    }

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    public StackoneListStepLogsRequest withFilter(Filter filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = JsonNullable.of(filter);
        return this;
    }

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    public StackoneListStepLogsRequest withFilter(JsonNullable<? extends Filter> filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = filter;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneListStepLogsRequest other = (StackoneListStepLogsRequest) o;
        return 
            Objects.deepEquals(this.orderBy, other.orderBy) &&
            Objects.deepEquals(this.orderDirection, other.orderDirection) &&
            Objects.deepEquals(this.pageSize, other.pageSize) &&
            Objects.deepEquals(this.next, other.next) &&
            Objects.deepEquals(this.filter, other.filter);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            orderBy,
            orderDirection,
            pageSize,
            next,
            filter);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneListStepLogsRequest.class,
                "orderBy", orderBy,
                "orderDirection", orderDirection,
                "pageSize", pageSize,
                "next", next,
                "filter", filter);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends OrderBy> orderBy = JsonNullable.undefined();
 
        private JsonNullable<? extends OrderDirection> orderDirection = JsonNullable.undefined();
 
        private JsonNullable<Double> pageSize = JsonNullable.undefined();
 
        private JsonNullable<String> next = JsonNullable.undefined();
 
        private JsonNullable<? extends Filter> filter = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The field to order the results by.
         */
        public Builder orderBy(OrderBy orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = JsonNullable.of(orderBy);
            return this;
        }

        /**
         * The field to order the results by.
         */
        public Builder orderBy(JsonNullable<? extends OrderBy> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }

        /**
         * The direction to order the results by.
         */
        public Builder orderDirection(OrderDirection orderDirection) {
            Utils.checkNotNull(orderDirection, "orderDirection");
            this.orderDirection = JsonNullable.of(orderDirection);
            return this;
        }

        /**
         * The direction to order the results by.
         */
        public Builder orderDirection(JsonNullable<? extends OrderDirection> orderDirection) {
            Utils.checkNotNull(orderDirection, "orderDirection");
            this.orderDirection = orderDirection;
            return this;
        }

        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(double pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = JsonNullable.of(pageSize);
            return this;
        }

        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(JsonNullable<Double> pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = pageSize;
            return this;
        }

        /**
         * The unified cursor
         */
        public Builder next(String next) {
            Utils.checkNotNull(next, "next");
            this.next = JsonNullable.of(next);
            return this;
        }

        /**
         * The unified cursor
         */
        public Builder next(JsonNullable<String> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        /**
         * Filter parameters that allow greater customisation of the list response
         */
        public Builder filter(Filter filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = JsonNullable.of(filter);
            return this;
        }

        /**
         * Filter parameters that allow greater customisation of the list response
         */
        public Builder filter(JsonNullable<? extends Filter> filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = filter;
            return this;
        }
        
        public StackoneListStepLogsRequest build() {
            return new StackoneListStepLogsRequest(
                orderBy,
                orderDirection,
                pageSize,
                next,
                filter);
        }
    }
}
