/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * TimeOffDurationUnit
 * 
 * <p>The duration unit of the current policy
 */
public class TimeOffDurationUnit {

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends TimeOffPolicyDurationUnitValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends TimeOffPolicyDurationUnitSourceValue> sourceValue;

    @JsonCreator
    public TimeOffDurationUnit(
            @JsonProperty("value") JsonNullable<? extends TimeOffPolicyDurationUnitValue> value,
            @JsonProperty("source_value") JsonNullable<? extends TimeOffPolicyDurationUnitSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public TimeOffDurationUnit() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffPolicyDurationUnitValue> value() {
        return (JsonNullable<TimeOffPolicyDurationUnitValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffPolicyDurationUnitSourceValue> sourceValue() {
        return (JsonNullable<TimeOffPolicyDurationUnitSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    public TimeOffDurationUnit withValue(TimeOffPolicyDurationUnitValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    public TimeOffDurationUnit withValue(JsonNullable<? extends TimeOffPolicyDurationUnitValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public TimeOffDurationUnit withSourceValue(TimeOffPolicyDurationUnitSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public TimeOffDurationUnit withSourceValue(JsonNullable<? extends TimeOffPolicyDurationUnitSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TimeOffDurationUnit other = (TimeOffDurationUnit) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TimeOffDurationUnit.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends TimeOffPolicyDurationUnitValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends TimeOffPolicyDurationUnitSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
         */
        public Builder value(TimeOffPolicyDurationUnitValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
         */
        public Builder value(JsonNullable<? extends TimeOffPolicyDurationUnitValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(TimeOffPolicyDurationUnitSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends TimeOffPolicyDurationUnitSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public TimeOffDurationUnit build() {
            return new TimeOffDurationUnit(
                value,
                sourceValue);
        }
    }
}
