/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.RejectedReasonResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AtsGetRejectedReasonResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The rejected reason with the given identifier was retrieved.
     */
    private Optional<? extends RejectedReasonResult> rejectedReasonResult;

    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetRejectedReasonResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends RejectedReasonResult> rejectedReasonResult,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.rejectedReasonResult = rejectedReasonResult;
        this.headers = headers;
    }
    
    public AtsGetRejectedReasonResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The rejected reason with the given identifier was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<RejectedReasonResult> rejectedReasonResult() {
        return (Optional<RejectedReasonResult>) rejectedReasonResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * HTTP response content type for this operation
     */
    public AtsGetRejectedReasonResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public AtsGetRejectedReasonResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public AtsGetRejectedReasonResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The rejected reason with the given identifier was retrieved.
     */
    public AtsGetRejectedReasonResponse withRejectedReasonResult(RejectedReasonResult rejectedReasonResult) {
        Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
        this.rejectedReasonResult = Optional.ofNullable(rejectedReasonResult);
        return this;
    }

    /**
     * The rejected reason with the given identifier was retrieved.
     */
    public AtsGetRejectedReasonResponse withRejectedReasonResult(Optional<? extends RejectedReasonResult> rejectedReasonResult) {
        Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
        this.rejectedReasonResult = rejectedReasonResult;
        return this;
    }

    public AtsGetRejectedReasonResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsGetRejectedReasonResponse other = (AtsGetRejectedReasonResponse) o;
        return 
            Objects.deepEquals(this.contentType, other.contentType) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.rawResponse, other.rawResponse) &&
            Objects.deepEquals(this.rejectedReasonResult, other.rejectedReasonResult) &&
            Objects.deepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            contentType,
            statusCode,
            rawResponse,
            rejectedReasonResult,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsGetRejectedReasonResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "rejectedReasonResult", rejectedReasonResult,
                "headers", headers);
    }
    
    public final static class Builder {
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends RejectedReasonResult> rejectedReasonResult = Optional.empty();
 
        private Map<String, List<String>> headers;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The rejected reason with the given identifier was retrieved.
         */
        public Builder rejectedReasonResult(RejectedReasonResult rejectedReasonResult) {
            Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
            this.rejectedReasonResult = Optional.ofNullable(rejectedReasonResult);
            return this;
        }

        /**
         * The rejected reason with the given identifier was retrieved.
         */
        public Builder rejectedReasonResult(Optional<? extends RejectedReasonResult> rejectedReasonResult) {
            Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
            this.rejectedReasonResult = rejectedReasonResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }
        
        public AtsGetRejectedReasonResponse build() {
            return new AtsGetRejectedReasonResponse(
                contentType,
                statusCode,
                rawResponse,
                rejectedReasonResult,
                headers);
        }
    }
}
