/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.IamResourceSourceValue;
import com.stackone.stackone_client_java.models.components.IamResourceValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class IamResourceType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends IamResourceValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends IamResourceSourceValue> sourceValue;

    @JsonCreator
    public IamResourceType(@JsonProperty(value="value") JsonNullable<? extends IamResourceValue> value, @JsonProperty(value="source_value") JsonNullable<? extends IamResourceSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public IamResourceType() {
        this((JsonNullable<? extends IamResourceValue>)JsonNullable.undefined(), (JsonNullable<? extends IamResourceSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<IamResourceValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<IamResourceSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IamResourceType withValue(IamResourceValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public IamResourceType withValue(JsonNullable<? extends IamResourceValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public IamResourceType withSourceValue(IamResourceSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public IamResourceType withSourceValue(JsonNullable<? extends IamResourceSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamResourceType other = (IamResourceType)o;
        return Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(IamResourceType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends IamResourceValue> value = JsonNullable.undefined();
        private JsonNullable<? extends IamResourceSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(IamResourceValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends IamResourceValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(IamResourceSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends IamResourceSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public IamResourceType build() {
            return new IamResourceType(this.value, this.sourceValue);
        }
    }
}

