/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;

public class LinkedAccountMeta {

    @JsonProperty("provider")
    private String provider;

    @JsonProperty("category")
    private LinkedAccountMetaCategory category;

    @JsonProperty("models")
    private Map<String, Object> models;

    @JsonCreator
    public LinkedAccountMeta(
            @JsonProperty("provider") String provider,
            @JsonProperty("category") LinkedAccountMetaCategory category,
            @JsonProperty("models") Map<String, Object> models) {
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(category, "category");
        models = Utils.emptyMapIfNull(models);
        this.provider = provider;
        this.category = category;
        this.models = models;
    }

    @JsonIgnore
    public String provider() {
        return provider;
    }

    @JsonIgnore
    public LinkedAccountMetaCategory category() {
        return category;
    }

    @JsonIgnore
    public Map<String, Object> models() {
        return models;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public LinkedAccountMeta withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public LinkedAccountMeta withCategory(LinkedAccountMetaCategory category) {
        Utils.checkNotNull(category, "category");
        this.category = category;
        return this;
    }

    public LinkedAccountMeta withModels(Map<String, Object> models) {
        Utils.checkNotNull(models, "models");
        this.models = models;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkedAccountMeta other = (LinkedAccountMeta) o;
        return 
            Utils.enhancedDeepEquals(this.provider, other.provider) &&
            Utils.enhancedDeepEquals(this.category, other.category) &&
            Utils.enhancedDeepEquals(this.models, other.models);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            provider,
            category,
            models);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkedAccountMeta.class,
                "provider", provider,
                "category", category,
                "models", models);
    }
    
    public final static class Builder {
 
        private String provider;
 
        private LinkedAccountMetaCategory category;
 
        private Map<String, Object> models;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder category(LinkedAccountMetaCategory category) {
            Utils.checkNotNull(category, "category");
            this.category = category;
            return this;
        }

        public Builder models(Map<String, Object> models) {
            Utils.checkNotNull(models, "models");
            this.models = models;
            return this;
        }
        
        public LinkedAccountMeta build() {
            return new LinkedAccountMeta(
                provider,
                category,
                models);
        }
    }
}
