/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class ScheduledInterview {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("application_id")
    private JsonNullable<String> applicationId;

    /**
     * Provider's unique identifier of the application
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_application_id")
    private JsonNullable<String> remoteApplicationId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interview_stage_id")
    private JsonNullable<String> interviewStageId;

    /**
     * Provider's unique identifier of the interview stage
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_interview_stage_id")
    private JsonNullable<String> remoteInterviewStageId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interview_stage")
    private JsonNullable<? extends ScheduledInterviewInterviewStage> interviewStage;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interview_status")
    private JsonNullable<? extends InterviewStatus> interviewStatus;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interviewer_ids")
    private JsonNullable<? extends List<String>> interviewerIds;

    /**
     * Provider's unique identifiers of the interviewers
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_interviewer_ids")
    private JsonNullable<? extends List<String>> remoteInterviewerIds;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interview_parts")
    private JsonNullable<? extends List<InterviewPart>> interviewParts;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interviewers")
    private JsonNullable<? extends List<Interviewer>> interviewers;

    /**
     * Interview start date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_at")
    private JsonNullable<OffsetDateTime> startAt;

    /**
     * Interview end date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_at")
    private JsonNullable<OffsetDateTime> endAt;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("meeting_url")
    private JsonNullable<String> meetingUrl;

    /**
     * Interview created date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Interview updated date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public ScheduledInterview(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("application_id") JsonNullable<String> applicationId,
            @JsonProperty("remote_application_id") JsonNullable<String> remoteApplicationId,
            @JsonProperty("interview_stage_id") JsonNullable<String> interviewStageId,
            @JsonProperty("remote_interview_stage_id") JsonNullable<String> remoteInterviewStageId,
            @JsonProperty("interview_stage") JsonNullable<? extends ScheduledInterviewInterviewStage> interviewStage,
            @JsonProperty("interview_status") JsonNullable<? extends InterviewStatus> interviewStatus,
            @JsonProperty("interviewer_ids") JsonNullable<? extends List<String>> interviewerIds,
            @JsonProperty("remote_interviewer_ids") JsonNullable<? extends List<String>> remoteInterviewerIds,
            @JsonProperty("interview_parts") JsonNullable<? extends List<InterviewPart>> interviewParts,
            @JsonProperty("interviewers") JsonNullable<? extends List<Interviewer>> interviewers,
            @JsonProperty("start_at") JsonNullable<OffsetDateTime> startAt,
            @JsonProperty("end_at") JsonNullable<OffsetDateTime> endAt,
            @JsonProperty("meeting_url") JsonNullable<String> meetingUrl,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(applicationId, "applicationId");
        Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
        Utils.checkNotNull(interviewStageId, "interviewStageId");
        Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
        Utils.checkNotNull(interviewStage, "interviewStage");
        Utils.checkNotNull(interviewStatus, "interviewStatus");
        Utils.checkNotNull(interviewerIds, "interviewerIds");
        Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
        Utils.checkNotNull(interviewParts, "interviewParts");
        Utils.checkNotNull(interviewers, "interviewers");
        Utils.checkNotNull(startAt, "startAt");
        Utils.checkNotNull(endAt, "endAt");
        Utils.checkNotNull(meetingUrl, "meetingUrl");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.applicationId = applicationId;
        this.remoteApplicationId = remoteApplicationId;
        this.interviewStageId = interviewStageId;
        this.remoteInterviewStageId = remoteInterviewStageId;
        this.interviewStage = interviewStage;
        this.interviewStatus = interviewStatus;
        this.interviewerIds = interviewerIds;
        this.remoteInterviewerIds = remoteInterviewerIds;
        this.interviewParts = interviewParts;
        this.interviewers = interviewers;
        this.startAt = startAt;
        this.endAt = endAt;
        this.meetingUrl = meetingUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public ScheduledInterview() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    @JsonIgnore
    public JsonNullable<String> applicationId() {
        return applicationId;
    }

    /**
     * Provider's unique identifier of the application
     */
    @JsonIgnore
    public JsonNullable<String> remoteApplicationId() {
        return remoteApplicationId;
    }

    @JsonIgnore
    public JsonNullable<String> interviewStageId() {
        return interviewStageId;
    }

    /**
     * Provider's unique identifier of the interview stage
     */
    @JsonIgnore
    public JsonNullable<String> remoteInterviewStageId() {
        return remoteInterviewStageId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ScheduledInterviewInterviewStage> interviewStage() {
        return (JsonNullable<ScheduledInterviewInterviewStage>) interviewStage;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<InterviewStatus> interviewStatus() {
        return (JsonNullable<InterviewStatus>) interviewStatus;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> interviewerIds() {
        return (JsonNullable<List<String>>) interviewerIds;
    }

    /**
     * Provider's unique identifiers of the interviewers
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteInterviewerIds() {
        return (JsonNullable<List<String>>) remoteInterviewerIds;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<InterviewPart>> interviewParts() {
        return (JsonNullable<List<InterviewPart>>) interviewParts;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Interviewer>> interviewers() {
        return (JsonNullable<List<Interviewer>>) interviewers;
    }

    /**
     * Interview start date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startAt() {
        return startAt;
    }

    /**
     * Interview end date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endAt() {
        return endAt;
    }

    @JsonIgnore
    public JsonNullable<String> meetingUrl() {
        return meetingUrl;
    }

    /**
     * Interview created date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Interview updated date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public ScheduledInterview withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public ScheduledInterview withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public ScheduledInterview withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public ScheduledInterview withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public ScheduledInterview withApplicationId(String applicationId) {
        Utils.checkNotNull(applicationId, "applicationId");
        this.applicationId = JsonNullable.of(applicationId);
        return this;
    }

    public ScheduledInterview withApplicationId(JsonNullable<String> applicationId) {
        Utils.checkNotNull(applicationId, "applicationId");
        this.applicationId = applicationId;
        return this;
    }

    /**
     * Provider's unique identifier of the application
     */
    public ScheduledInterview withRemoteApplicationId(String remoteApplicationId) {
        Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
        this.remoteApplicationId = JsonNullable.of(remoteApplicationId);
        return this;
    }

    /**
     * Provider's unique identifier of the application
     */
    public ScheduledInterview withRemoteApplicationId(JsonNullable<String> remoteApplicationId) {
        Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
        this.remoteApplicationId = remoteApplicationId;
        return this;
    }

    public ScheduledInterview withInterviewStageId(String interviewStageId) {
        Utils.checkNotNull(interviewStageId, "interviewStageId");
        this.interviewStageId = JsonNullable.of(interviewStageId);
        return this;
    }

    public ScheduledInterview withInterviewStageId(JsonNullable<String> interviewStageId) {
        Utils.checkNotNull(interviewStageId, "interviewStageId");
        this.interviewStageId = interviewStageId;
        return this;
    }

    /**
     * Provider's unique identifier of the interview stage
     */
    public ScheduledInterview withRemoteInterviewStageId(String remoteInterviewStageId) {
        Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
        this.remoteInterviewStageId = JsonNullable.of(remoteInterviewStageId);
        return this;
    }

    /**
     * Provider's unique identifier of the interview stage
     */
    public ScheduledInterview withRemoteInterviewStageId(JsonNullable<String> remoteInterviewStageId) {
        Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
        this.remoteInterviewStageId = remoteInterviewStageId;
        return this;
    }

    public ScheduledInterview withInterviewStage(ScheduledInterviewInterviewStage interviewStage) {
        Utils.checkNotNull(interviewStage, "interviewStage");
        this.interviewStage = JsonNullable.of(interviewStage);
        return this;
    }

    public ScheduledInterview withInterviewStage(JsonNullable<? extends ScheduledInterviewInterviewStage> interviewStage) {
        Utils.checkNotNull(interviewStage, "interviewStage");
        this.interviewStage = interviewStage;
        return this;
    }

    public ScheduledInterview withInterviewStatus(InterviewStatus interviewStatus) {
        Utils.checkNotNull(interviewStatus, "interviewStatus");
        this.interviewStatus = JsonNullable.of(interviewStatus);
        return this;
    }

    public ScheduledInterview withInterviewStatus(JsonNullable<? extends InterviewStatus> interviewStatus) {
        Utils.checkNotNull(interviewStatus, "interviewStatus");
        this.interviewStatus = interviewStatus;
        return this;
    }

    public ScheduledInterview withInterviewerIds(List<String> interviewerIds) {
        Utils.checkNotNull(interviewerIds, "interviewerIds");
        this.interviewerIds = JsonNullable.of(interviewerIds);
        return this;
    }

    public ScheduledInterview withInterviewerIds(JsonNullable<? extends List<String>> interviewerIds) {
        Utils.checkNotNull(interviewerIds, "interviewerIds");
        this.interviewerIds = interviewerIds;
        return this;
    }

    /**
     * Provider's unique identifiers of the interviewers
     */
    public ScheduledInterview withRemoteInterviewerIds(List<String> remoteInterviewerIds) {
        Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
        this.remoteInterviewerIds = JsonNullable.of(remoteInterviewerIds);
        return this;
    }

    /**
     * Provider's unique identifiers of the interviewers
     */
    public ScheduledInterview withRemoteInterviewerIds(JsonNullable<? extends List<String>> remoteInterviewerIds) {
        Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
        this.remoteInterviewerIds = remoteInterviewerIds;
        return this;
    }

    public ScheduledInterview withInterviewParts(List<InterviewPart> interviewParts) {
        Utils.checkNotNull(interviewParts, "interviewParts");
        this.interviewParts = JsonNullable.of(interviewParts);
        return this;
    }

    public ScheduledInterview withInterviewParts(JsonNullable<? extends List<InterviewPart>> interviewParts) {
        Utils.checkNotNull(interviewParts, "interviewParts");
        this.interviewParts = interviewParts;
        return this;
    }

    public ScheduledInterview withInterviewers(List<Interviewer> interviewers) {
        Utils.checkNotNull(interviewers, "interviewers");
        this.interviewers = JsonNullable.of(interviewers);
        return this;
    }

    public ScheduledInterview withInterviewers(JsonNullable<? extends List<Interviewer>> interviewers) {
        Utils.checkNotNull(interviewers, "interviewers");
        this.interviewers = interviewers;
        return this;
    }

    /**
     * Interview start date
     */
    public ScheduledInterview withStartAt(OffsetDateTime startAt) {
        Utils.checkNotNull(startAt, "startAt");
        this.startAt = JsonNullable.of(startAt);
        return this;
    }

    /**
     * Interview start date
     */
    public ScheduledInterview withStartAt(JsonNullable<OffsetDateTime> startAt) {
        Utils.checkNotNull(startAt, "startAt");
        this.startAt = startAt;
        return this;
    }

    /**
     * Interview end date
     */
    public ScheduledInterview withEndAt(OffsetDateTime endAt) {
        Utils.checkNotNull(endAt, "endAt");
        this.endAt = JsonNullable.of(endAt);
        return this;
    }

    /**
     * Interview end date
     */
    public ScheduledInterview withEndAt(JsonNullable<OffsetDateTime> endAt) {
        Utils.checkNotNull(endAt, "endAt");
        this.endAt = endAt;
        return this;
    }

    public ScheduledInterview withMeetingUrl(String meetingUrl) {
        Utils.checkNotNull(meetingUrl, "meetingUrl");
        this.meetingUrl = JsonNullable.of(meetingUrl);
        return this;
    }

    public ScheduledInterview withMeetingUrl(JsonNullable<String> meetingUrl) {
        Utils.checkNotNull(meetingUrl, "meetingUrl");
        this.meetingUrl = meetingUrl;
        return this;
    }

    /**
     * Interview created date
     */
    public ScheduledInterview withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Interview created date
     */
    public ScheduledInterview withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Interview updated date
     */
    public ScheduledInterview withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * Interview updated date
     */
    public ScheduledInterview withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScheduledInterview other = (ScheduledInterview) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.applicationId, other.applicationId) &&
            Utils.enhancedDeepEquals(this.remoteApplicationId, other.remoteApplicationId) &&
            Utils.enhancedDeepEquals(this.interviewStageId, other.interviewStageId) &&
            Utils.enhancedDeepEquals(this.remoteInterviewStageId, other.remoteInterviewStageId) &&
            Utils.enhancedDeepEquals(this.interviewStage, other.interviewStage) &&
            Utils.enhancedDeepEquals(this.interviewStatus, other.interviewStatus) &&
            Utils.enhancedDeepEquals(this.interviewerIds, other.interviewerIds) &&
            Utils.enhancedDeepEquals(this.remoteInterviewerIds, other.remoteInterviewerIds) &&
            Utils.enhancedDeepEquals(this.interviewParts, other.interviewParts) &&
            Utils.enhancedDeepEquals(this.interviewers, other.interviewers) &&
            Utils.enhancedDeepEquals(this.startAt, other.startAt) &&
            Utils.enhancedDeepEquals(this.endAt, other.endAt) &&
            Utils.enhancedDeepEquals(this.meetingUrl, other.meetingUrl) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            remoteId,
            applicationId,
            remoteApplicationId,
            interviewStageId,
            remoteInterviewStageId,
            interviewStage,
            interviewStatus,
            interviewerIds,
            remoteInterviewerIds,
            interviewParts,
            interviewers,
            startAt,
            endAt,
            meetingUrl,
            createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ScheduledInterview.class,
                "id", id,
                "remoteId", remoteId,
                "applicationId", applicationId,
                "remoteApplicationId", remoteApplicationId,
                "interviewStageId", interviewStageId,
                "remoteInterviewStageId", remoteInterviewStageId,
                "interviewStage", interviewStage,
                "interviewStatus", interviewStatus,
                "interviewerIds", interviewerIds,
                "remoteInterviewerIds", remoteInterviewerIds,
                "interviewParts", interviewParts,
                "interviewers", interviewers,
                "startAt", startAt,
                "endAt", endAt,
                "meetingUrl", meetingUrl,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<String> applicationId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteApplicationId = JsonNullable.undefined();
 
        private JsonNullable<String> interviewStageId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteInterviewStageId = JsonNullable.undefined();
 
        private JsonNullable<? extends ScheduledInterviewInterviewStage> interviewStage = JsonNullable.undefined();
 
        private JsonNullable<? extends InterviewStatus> interviewStatus = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> interviewerIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> remoteInterviewerIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<InterviewPart>> interviewParts = JsonNullable.undefined();
 
        private JsonNullable<? extends List<Interviewer>> interviewers = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> startAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> endAt = JsonNullable.undefined();
 
        private JsonNullable<String> meetingUrl = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder applicationId(String applicationId) {
            Utils.checkNotNull(applicationId, "applicationId");
            this.applicationId = JsonNullable.of(applicationId);
            return this;
        }

        public Builder applicationId(JsonNullable<String> applicationId) {
            Utils.checkNotNull(applicationId, "applicationId");
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Provider's unique identifier of the application
         */
        public Builder remoteApplicationId(String remoteApplicationId) {
            Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
            this.remoteApplicationId = JsonNullable.of(remoteApplicationId);
            return this;
        }

        /**
         * Provider's unique identifier of the application
         */
        public Builder remoteApplicationId(JsonNullable<String> remoteApplicationId) {
            Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
            this.remoteApplicationId = remoteApplicationId;
            return this;
        }

        public Builder interviewStageId(String interviewStageId) {
            Utils.checkNotNull(interviewStageId, "interviewStageId");
            this.interviewStageId = JsonNullable.of(interviewStageId);
            return this;
        }

        public Builder interviewStageId(JsonNullable<String> interviewStageId) {
            Utils.checkNotNull(interviewStageId, "interviewStageId");
            this.interviewStageId = interviewStageId;
            return this;
        }

        /**
         * Provider's unique identifier of the interview stage
         */
        public Builder remoteInterviewStageId(String remoteInterviewStageId) {
            Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
            this.remoteInterviewStageId = JsonNullable.of(remoteInterviewStageId);
            return this;
        }

        /**
         * Provider's unique identifier of the interview stage
         */
        public Builder remoteInterviewStageId(JsonNullable<String> remoteInterviewStageId) {
            Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
            this.remoteInterviewStageId = remoteInterviewStageId;
            return this;
        }

        public Builder interviewStage(ScheduledInterviewInterviewStage interviewStage) {
            Utils.checkNotNull(interviewStage, "interviewStage");
            this.interviewStage = JsonNullable.of(interviewStage);
            return this;
        }

        public Builder interviewStage(JsonNullable<? extends ScheduledInterviewInterviewStage> interviewStage) {
            Utils.checkNotNull(interviewStage, "interviewStage");
            this.interviewStage = interviewStage;
            return this;
        }

        public Builder interviewStatus(InterviewStatus interviewStatus) {
            Utils.checkNotNull(interviewStatus, "interviewStatus");
            this.interviewStatus = JsonNullable.of(interviewStatus);
            return this;
        }

        public Builder interviewStatus(JsonNullable<? extends InterviewStatus> interviewStatus) {
            Utils.checkNotNull(interviewStatus, "interviewStatus");
            this.interviewStatus = interviewStatus;
            return this;
        }

        public Builder interviewerIds(List<String> interviewerIds) {
            Utils.checkNotNull(interviewerIds, "interviewerIds");
            this.interviewerIds = JsonNullable.of(interviewerIds);
            return this;
        }

        public Builder interviewerIds(JsonNullable<? extends List<String>> interviewerIds) {
            Utils.checkNotNull(interviewerIds, "interviewerIds");
            this.interviewerIds = interviewerIds;
            return this;
        }

        /**
         * Provider's unique identifiers of the interviewers
         */
        public Builder remoteInterviewerIds(List<String> remoteInterviewerIds) {
            Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
            this.remoteInterviewerIds = JsonNullable.of(remoteInterviewerIds);
            return this;
        }

        /**
         * Provider's unique identifiers of the interviewers
         */
        public Builder remoteInterviewerIds(JsonNullable<? extends List<String>> remoteInterviewerIds) {
            Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
            this.remoteInterviewerIds = remoteInterviewerIds;
            return this;
        }

        public Builder interviewParts(List<InterviewPart> interviewParts) {
            Utils.checkNotNull(interviewParts, "interviewParts");
            this.interviewParts = JsonNullable.of(interviewParts);
            return this;
        }

        public Builder interviewParts(JsonNullable<? extends List<InterviewPart>> interviewParts) {
            Utils.checkNotNull(interviewParts, "interviewParts");
            this.interviewParts = interviewParts;
            return this;
        }

        public Builder interviewers(List<Interviewer> interviewers) {
            Utils.checkNotNull(interviewers, "interviewers");
            this.interviewers = JsonNullable.of(interviewers);
            return this;
        }

        public Builder interviewers(JsonNullable<? extends List<Interviewer>> interviewers) {
            Utils.checkNotNull(interviewers, "interviewers");
            this.interviewers = interviewers;
            return this;
        }

        /**
         * Interview start date
         */
        public Builder startAt(OffsetDateTime startAt) {
            Utils.checkNotNull(startAt, "startAt");
            this.startAt = JsonNullable.of(startAt);
            return this;
        }

        /**
         * Interview start date
         */
        public Builder startAt(JsonNullable<OffsetDateTime> startAt) {
            Utils.checkNotNull(startAt, "startAt");
            this.startAt = startAt;
            return this;
        }

        /**
         * Interview end date
         */
        public Builder endAt(OffsetDateTime endAt) {
            Utils.checkNotNull(endAt, "endAt");
            this.endAt = JsonNullable.of(endAt);
            return this;
        }

        /**
         * Interview end date
         */
        public Builder endAt(JsonNullable<OffsetDateTime> endAt) {
            Utils.checkNotNull(endAt, "endAt");
            this.endAt = endAt;
            return this;
        }

        public Builder meetingUrl(String meetingUrl) {
            Utils.checkNotNull(meetingUrl, "meetingUrl");
            this.meetingUrl = JsonNullable.of(meetingUrl);
            return this;
        }

        public Builder meetingUrl(JsonNullable<String> meetingUrl) {
            Utils.checkNotNull(meetingUrl, "meetingUrl");
            this.meetingUrl = meetingUrl;
            return this;
        }

        /**
         * Interview created date
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Interview created date
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * Interview updated date
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * Interview updated date
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }
        
        public ScheduledInterview build() {
            return new ScheduledInterview(
                id,
                remoteId,
                applicationId,
                remoteApplicationId,
                interviewStageId,
                remoteInterviewStageId,
                interviewStage,
                interviewStatus,
                interviewerIds,
                remoteInterviewerIds,
                interviewParts,
                interviewers,
                startAt,
                endAt,
                meetingUrl,
                createdAt,
                updatedAt);
        }
    }
}
