/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.EmploymentSourceValue;
import com.stackone.stackone_client_java.models.components.EmploymentValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class PayPeriod {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends EmploymentValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends EmploymentSourceValue> sourceValue;

    @JsonCreator
    public PayPeriod(@JsonProperty(value="value") JsonNullable<? extends EmploymentValue> value, @JsonProperty(value="source_value") JsonNullable<? extends EmploymentSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public PayPeriod() {
        this((JsonNullable<? extends EmploymentValue>)JsonNullable.undefined(), (JsonNullable<? extends EmploymentSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<EmploymentValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<EmploymentSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public PayPeriod withValue(EmploymentValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public PayPeriod withValue(JsonNullable<? extends EmploymentValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public PayPeriod withSourceValue(EmploymentSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public PayPeriod withSourceValue(JsonNullable<? extends EmploymentSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayPeriod other = (PayPeriod)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(PayPeriod.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends EmploymentValue> value = JsonNullable.undefined();
        private JsonNullable<? extends EmploymentSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(EmploymentValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends EmploymentValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(EmploymentSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends EmploymentSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public PayPeriod build() {
            return new PayPeriod(this.value, this.sourceValue);
        }
    }
}

