/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.http.HttpResponse;
import java.net.http.HttpRequest;
import java.util.concurrent.CompletableFuture;

public interface HTTPClient {

    /**
     * Sends an HTTP request and returns the response.
     * 
     * <p>Note that {@link HttpRequest} is immutable. To modify the request you can use
     * {@code HttpRequest#newBuilder(HttpRequest, BiPredicate<String, String>)} with 
     * JDK 16 and later (which will copy the request for modification in a builder). 
     * If that method is not available then use {@link Helpers#copy} (which also returns
     * a builder).  
     * 
     * @param request HTTP request
     * @return HTTP response
     * @throws IOException
     * @throws InterruptedException
     * @throws URISyntaxException
     */    
    HttpResponse<InputStream> send(HttpRequest request)
            throws IOException, InterruptedException, URISyntaxException;

    /**
     * Controls the debug flag that can be used by clients to perform conditional
     * debugging actions like logging HTTP requests and responses.
     * This is currently implemented in SpeakeasyHTTPClient but custom client
     * implementations are free to use this method similarly if they wish.
     *
     * @param enabled Whether to enable debug flag
     */
    default void enableDebugLogging(boolean enabled) {
        // do nothing
    }

    /**
     * Returns whether debug logging is enabled.
     *
     * @return Whether debug logging is enabled
     */
    default boolean isDebugLoggingEnabled() {
        return false;
    }
}
