/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AssignmentValue {
    public static final AssignmentValue PENDING = new AssignmentValue("pending");
    public static final AssignmentValue IN_PROGRESS = new AssignmentValue("in_progress");
    public static final AssignmentValue COMPLETED = new AssignmentValue("completed");
    public static final AssignmentValue UNMAPPED_VALUE = new AssignmentValue("unmapped_value");
    private static final Map<String, AssignmentValue> values = AssignmentValue.createValuesMap();
    private static final Map<String, AssignmentValueEnum> enums = AssignmentValue.createEnumsMap();
    private final String value;

    private AssignmentValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssignmentValue of(String value) {
        Class<AssignmentValue> clazz = AssignmentValue.class;
        synchronized (AssignmentValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AssignmentValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AssignmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssignmentValue other = (AssignmentValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AssignmentValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssignmentValue[] values() {
        Class<AssignmentValue> clazz = AssignmentValue.class;
        synchronized (AssignmentValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AssignmentValue[0]);
        }
    }

    private static final Map<String, AssignmentValue> createValuesMap() {
        LinkedHashMap<String, AssignmentValue> map = new LinkedHashMap<String, AssignmentValue>();
        map.put("pending", PENDING);
        map.put("in_progress", IN_PROGRESS);
        map.put("completed", COMPLETED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AssignmentValueEnum> createEnumsMap() {
        HashMap<String, AssignmentValueEnum> map = new HashMap<String, AssignmentValueEnum>();
        map.put("pending", AssignmentValueEnum.PENDING);
        map.put("in_progress", AssignmentValueEnum.IN_PROGRESS);
        map.put("completed", AssignmentValueEnum.COMPLETED);
        map.put("unmapped_value", AssignmentValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AssignmentValueEnum {
        PENDING("pending"),
        IN_PROGRESS("in_progress"),
        COMPLETED("completed"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AssignmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AssignmentValue> {
        protected _Deserializer() {
            super(AssignmentValue.class);
        }

        public AssignmentValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AssignmentValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AssignmentValue> {
        protected _Serializer() {
            super(AssignmentValue.class);
        }

        public void serialize(AssignmentValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

