/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.LmsListCoursesRequest;
import com.stackone.stackone_client_java.models.operations.LmsListCoursesResponse;
import com.stackone.stackone_client_java.operations.LmsListCoursesOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class LmsListCoursesRequestBuilder {
    private LmsListCoursesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public LmsListCoursesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsListCoursesRequestBuilder request(LmsListCoursesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsListCoursesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsListCoursesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public LmsListCoursesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListCoursesOperation operation = new LmsListCoursesOperation(this.sdkConfiguration, options);
        return (LmsListCoursesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<LmsListCoursesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListCoursesOperation operation = new LmsListCoursesOperation(this.sdkConfiguration, options);
        Paginator<LmsListCoursesRequest, String> iterator = new Paginator<LmsListCoursesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), LmsListCoursesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<LmsListCoursesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

