/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;


public class CandidateEmail {
    /**
     * Type of the email
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<String> type;

    /**
     * Email value
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<String> value;

    @JsonCreator
    public CandidateEmail(
            @JsonProperty("type") JsonNullable<String> type,
            @JsonProperty("value") JsonNullable<String> value) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(value, "value");
        this.type = type;
        this.value = value;
    }
    
    public CandidateEmail() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Type of the email
     */
    @JsonIgnore
    public JsonNullable<String> type() {
        return type;
    }

    /**
     * Email value
     */
    @JsonIgnore
    public JsonNullable<String> value() {
        return value;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Type of the email
     */
    public CandidateEmail withType(String type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * Type of the email
     */
    public CandidateEmail withType(JsonNullable<String> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * Email value
     */
    public CandidateEmail withValue(String value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * Email value
     */
    public CandidateEmail withValue(JsonNullable<String> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CandidateEmail other = (CandidateEmail) o;
        return 
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.value, other.value);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            type, value);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CandidateEmail.class,
                "type", type,
                "value", value);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> type = JsonNullable.undefined();

        private JsonNullable<String> value = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Type of the email
         */
        public Builder type(String type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * Type of the email
         */
        public Builder type(JsonNullable<String> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * Email value
         */
        public Builder value(String value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * Email value
         */
        public Builder value(JsonNullable<String> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public CandidateEmail build() {

            return new CandidateEmail(
                type, value);
        }

    }
}
