/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * PushMessagesValue
 * 
 * <p>The unified message type.
 */
@JsonDeserialize(using = PushMessagesValue._Deserializer.class)
@JsonSerialize(using = PushMessagesValue._Serializer.class)
public class PushMessagesValue {

    public static final PushMessagesValue EMAIL = new PushMessagesValue("email");
    public static final PushMessagesValue SMS = new PushMessagesValue("sms");
    public static final PushMessagesValue PUSH = new PushMessagesValue("push");
    public static final PushMessagesValue WEB_PUSH = new PushMessagesValue("web_push");
    public static final PushMessagesValue IOS_PUSH = new PushMessagesValue("ios_push");
    public static final PushMessagesValue ANDROID_PUSH = new PushMessagesValue("android_push");
    public static final PushMessagesValue APP_PUSH = new PushMessagesValue("app_push");
    public static final PushMessagesValue OMNI_CHANNEL = new PushMessagesValue("omni_channel");
    public static final PushMessagesValue CONTENT_BLOCK = new PushMessagesValue("content_block");
    public static final PushMessagesValue IN_APP = new PushMessagesValue("in_app");
    public static final PushMessagesValue UNKNOWN = new PushMessagesValue("unknown");
    public static final PushMessagesValue UNMAPPED_VALUE = new PushMessagesValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, PushMessagesValue> values = createValuesMap();
    private static final Map<String, PushMessagesValueEnum> enums = createEnumsMap();

    private final String value;

    private PushMessagesValue(String value) {
        this.value = value;
    }

    /**
     * Returns a PushMessagesValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as PushMessagesValue
     */ 
    public static PushMessagesValue of(String value) {
        synchronized (PushMessagesValue.class) {
            return values.computeIfAbsent(value, v -> new PushMessagesValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<PushMessagesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PushMessagesValue other = (PushMessagesValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "PushMessagesValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static PushMessagesValue[] values() {
        synchronized (PushMessagesValue.class) {
            return values.values().toArray(new PushMessagesValue[] {});
        }
    }

    private static final Map<String, PushMessagesValue> createValuesMap() {
        Map<String, PushMessagesValue> map = new LinkedHashMap<>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("push", PUSH);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("app_push", APP_PUSH);
        map.put("omni_channel", OMNI_CHANNEL);
        map.put("content_block", CONTENT_BLOCK);
        map.put("in_app", IN_APP);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, PushMessagesValueEnum> createEnumsMap() {
        Map<String, PushMessagesValueEnum> map = new HashMap<>();
        map.put("email", PushMessagesValueEnum.EMAIL);
        map.put("sms", PushMessagesValueEnum.SMS);
        map.put("push", PushMessagesValueEnum.PUSH);
        map.put("web_push", PushMessagesValueEnum.WEB_PUSH);
        map.put("ios_push", PushMessagesValueEnum.IOS_PUSH);
        map.put("android_push", PushMessagesValueEnum.ANDROID_PUSH);
        map.put("app_push", PushMessagesValueEnum.APP_PUSH);
        map.put("omni_channel", PushMessagesValueEnum.OMNI_CHANNEL);
        map.put("content_block", PushMessagesValueEnum.CONTENT_BLOCK);
        map.put("in_app", PushMessagesValueEnum.IN_APP);
        map.put("unknown", PushMessagesValueEnum.UNKNOWN);
        map.put("unmapped_value", PushMessagesValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<PushMessagesValue> {

        protected _Serializer() {
            super(PushMessagesValue.class);
        }

        @Override
        public void serialize(PushMessagesValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<PushMessagesValue> {

        protected _Deserializer() {
            super(PushMessagesValue.class);
        }

        @Override
        public PushMessagesValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return PushMessagesValue.of(v);
        }
    }
    
    public enum PushMessagesValueEnum {

        EMAIL("email"),
        SMS("sms"),
        PUSH("push"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        APP_PUSH("app_push"),
        OMNI_CHANNEL("omni_channel"),
        CONTENT_BLOCK("content_block"),
        IN_APP("in_app"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private PushMessagesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

