/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListLocationsRequest;
import com.stackone.stackone_client_java.models.operations.AtsListLocationsResponse;
import com.stackone.stackone_client_java.operations.AtsListLocationsOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class AtsListLocationsRequestBuilder {
    private AtsListLocationsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsListLocationsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListLocationsRequestBuilder request(AtsListLocationsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AtsListLocationsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListLocationsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AtsListLocationsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListLocationsOperation operation = new AtsListLocationsOperation(this.sdkConfiguration, options);
        return (AtsListLocationsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<AtsListLocationsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListLocationsOperation operation = new AtsListLocationsOperation(this.sdkConfiguration, options);
        Paginator<AtsListLocationsRequest, String> iterator = new Paginator<AtsListLocationsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), AtsListLocationsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<AtsListLocationsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

