/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;


public class ApplicationChanges {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Timestamp when the change was created
     */
    @JsonProperty("created_at")
    private OffsetDateTime createdAt;

    /**
     * Timestamp when the change became effective
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("effective_at")
    private JsonNullable<OffsetDateTime> effectiveAt;

    /**
     * The actor who made the change
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("actor")
    private JsonNullable<? extends Actor> actor;

    /**
     * The type of change that occurred to the application
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("change_type")
    private JsonNullable<? extends ChangeType> changeType;

    /**
     * The new values for changed application properties. Only includes fields that commonly change over the application lifecycle.
     */
    @JsonProperty("new_values")
    private ApplicationChangesDataModel newValues;

    @JsonCreator
    public ApplicationChanges(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("created_at") OffsetDateTime createdAt,
            @JsonProperty("effective_at") JsonNullable<OffsetDateTime> effectiveAt,
            @JsonProperty("actor") JsonNullable<? extends Actor> actor,
            @JsonProperty("change_type") JsonNullable<? extends ChangeType> changeType,
            @JsonProperty("new_values") ApplicationChangesDataModel newValues) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(effectiveAt, "effectiveAt");
        Utils.checkNotNull(actor, "actor");
        Utils.checkNotNull(changeType, "changeType");
        Utils.checkNotNull(newValues, "newValues");
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.effectiveAt = effectiveAt;
        this.actor = actor;
        this.changeType = changeType;
        this.newValues = newValues;
    }
    
    public ApplicationChanges(
            OffsetDateTime createdAt,
            ApplicationChangesDataModel newValues) {
        this(JsonNullable.undefined(), JsonNullable.undefined(), createdAt,
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            newValues);
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Timestamp when the change was created
     */
    @JsonIgnore
    public OffsetDateTime createdAt() {
        return createdAt;
    }

    /**
     * Timestamp when the change became effective
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> effectiveAt() {
        return effectiveAt;
    }

    /**
     * The actor who made the change
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Actor> actor() {
        return (JsonNullable<Actor>) actor;
    }

    /**
     * The type of change that occurred to the application
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ChangeType> changeType() {
        return (JsonNullable<ChangeType>) changeType;
    }

    /**
     * The new values for changed application properties. Only includes fields that commonly change over the application lifecycle.
     */
    @JsonIgnore
    public ApplicationChangesDataModel newValues() {
        return newValues;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public ApplicationChanges withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public ApplicationChanges withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public ApplicationChanges withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public ApplicationChanges withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Timestamp when the change was created
     */
    public ApplicationChanges withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Timestamp when the change became effective
     */
    public ApplicationChanges withEffectiveAt(OffsetDateTime effectiveAt) {
        Utils.checkNotNull(effectiveAt, "effectiveAt");
        this.effectiveAt = JsonNullable.of(effectiveAt);
        return this;
    }

    /**
     * Timestamp when the change became effective
     */
    public ApplicationChanges withEffectiveAt(JsonNullable<OffsetDateTime> effectiveAt) {
        Utils.checkNotNull(effectiveAt, "effectiveAt");
        this.effectiveAt = effectiveAt;
        return this;
    }

    /**
     * The actor who made the change
     */
    public ApplicationChanges withActor(Actor actor) {
        Utils.checkNotNull(actor, "actor");
        this.actor = JsonNullable.of(actor);
        return this;
    }

    /**
     * The actor who made the change
     */
    public ApplicationChanges withActor(JsonNullable<? extends Actor> actor) {
        Utils.checkNotNull(actor, "actor");
        this.actor = actor;
        return this;
    }

    /**
     * The type of change that occurred to the application
     */
    public ApplicationChanges withChangeType(ChangeType changeType) {
        Utils.checkNotNull(changeType, "changeType");
        this.changeType = JsonNullable.of(changeType);
        return this;
    }

    /**
     * The type of change that occurred to the application
     */
    public ApplicationChanges withChangeType(JsonNullable<? extends ChangeType> changeType) {
        Utils.checkNotNull(changeType, "changeType");
        this.changeType = changeType;
        return this;
    }

    /**
     * The new values for changed application properties. Only includes fields that commonly change over the application lifecycle.
     */
    public ApplicationChanges withNewValues(ApplicationChangesDataModel newValues) {
        Utils.checkNotNull(newValues, "newValues");
        this.newValues = newValues;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationChanges other = (ApplicationChanges) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.effectiveAt, other.effectiveAt) &&
            Utils.enhancedDeepEquals(this.actor, other.actor) &&
            Utils.enhancedDeepEquals(this.changeType, other.changeType) &&
            Utils.enhancedDeepEquals(this.newValues, other.newValues);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, createdAt,
            effectiveAt, actor, changeType,
            newValues);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ApplicationChanges.class,
                "id", id,
                "remoteId", remoteId,
                "createdAt", createdAt,
                "effectiveAt", effectiveAt,
                "actor", actor,
                "changeType", changeType,
                "newValues", newValues);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private OffsetDateTime createdAt;

        private JsonNullable<OffsetDateTime> effectiveAt = JsonNullable.undefined();

        private JsonNullable<? extends Actor> actor = JsonNullable.undefined();

        private JsonNullable<? extends ChangeType> changeType = JsonNullable.undefined();

        private ApplicationChangesDataModel newValues;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Timestamp when the change was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * Timestamp when the change became effective
         */
        public Builder effectiveAt(OffsetDateTime effectiveAt) {
            Utils.checkNotNull(effectiveAt, "effectiveAt");
            this.effectiveAt = JsonNullable.of(effectiveAt);
            return this;
        }

        /**
         * Timestamp when the change became effective
         */
        public Builder effectiveAt(JsonNullable<OffsetDateTime> effectiveAt) {
            Utils.checkNotNull(effectiveAt, "effectiveAt");
            this.effectiveAt = effectiveAt;
            return this;
        }


        /**
         * The actor who made the change
         */
        public Builder actor(Actor actor) {
            Utils.checkNotNull(actor, "actor");
            this.actor = JsonNullable.of(actor);
            return this;
        }

        /**
         * The actor who made the change
         */
        public Builder actor(JsonNullable<? extends Actor> actor) {
            Utils.checkNotNull(actor, "actor");
            this.actor = actor;
            return this;
        }


        /**
         * The type of change that occurred to the application
         */
        public Builder changeType(ChangeType changeType) {
            Utils.checkNotNull(changeType, "changeType");
            this.changeType = JsonNullable.of(changeType);
            return this;
        }

        /**
         * The type of change that occurred to the application
         */
        public Builder changeType(JsonNullable<? extends ChangeType> changeType) {
            Utils.checkNotNull(changeType, "changeType");
            this.changeType = changeType;
            return this;
        }


        /**
         * The new values for changed application properties. Only includes fields that commonly change over the application lifecycle.
         */
        public Builder newValues(ApplicationChangesDataModel newValues) {
            Utils.checkNotNull(newValues, "newValues");
            this.newValues = newValues;
            return this;
        }

        public ApplicationChanges build() {

            return new ApplicationChanges(
                id, remoteId, createdAt,
                effectiveAt, actor, changeType,
                newValues);
        }

    }
}
