/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * InterviewValue
 * 
 * <p>The status of the interview.
 */
@JsonDeserialize(using = InterviewValue._Deserializer.class)
@JsonSerialize(using = InterviewValue._Serializer.class)
public class InterviewValue {

    public static final InterviewValue UNSCHEDULED = new InterviewValue("unscheduled");
    public static final InterviewValue SCHEDULED = new InterviewValue("scheduled");
    public static final InterviewValue COMPLETED = new InterviewValue("completed");
    public static final InterviewValue CANCELLED = new InterviewValue("cancelled");
    public static final InterviewValue PENDING_FEEDBACK = new InterviewValue("pending_feedback");
    public static final InterviewValue UNMAPPED_VALUE = new InterviewValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, InterviewValue> values = createValuesMap();
    private static final Map<String, InterviewValueEnum> enums = createEnumsMap();

    private final String value;

    private InterviewValue(String value) {
        this.value = value;
    }

    /**
     * Returns a InterviewValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as InterviewValue
     */ 
    public static InterviewValue of(String value) {
        synchronized (InterviewValue.class) {
            return values.computeIfAbsent(value, v -> new InterviewValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<InterviewValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        InterviewValue other = (InterviewValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "InterviewValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static InterviewValue[] values() {
        synchronized (InterviewValue.class) {
            return values.values().toArray(new InterviewValue[] {});
        }
    }

    private static final Map<String, InterviewValue> createValuesMap() {
        Map<String, InterviewValue> map = new LinkedHashMap<>();
        map.put("unscheduled", UNSCHEDULED);
        map.put("scheduled", SCHEDULED);
        map.put("completed", COMPLETED);
        map.put("cancelled", CANCELLED);
        map.put("pending_feedback", PENDING_FEEDBACK);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, InterviewValueEnum> createEnumsMap() {
        Map<String, InterviewValueEnum> map = new HashMap<>();
        map.put("unscheduled", InterviewValueEnum.UNSCHEDULED);
        map.put("scheduled", InterviewValueEnum.SCHEDULED);
        map.put("completed", InterviewValueEnum.COMPLETED);
        map.put("cancelled", InterviewValueEnum.CANCELLED);
        map.put("pending_feedback", InterviewValueEnum.PENDING_FEEDBACK);
        map.put("unmapped_value", InterviewValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<InterviewValue> {

        protected _Serializer() {
            super(InterviewValue.class);
        }

        @Override
        public void serialize(InterviewValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<InterviewValue> {

        protected _Deserializer() {
            super(InterviewValue.class);
        }

        @Override
        public InterviewValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return InterviewValue.of(v);
        }
    }
    
    public enum InterviewValueEnum {

        UNSCHEDULED("unscheduled"),
        SCHEDULED("scheduled"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        PENDING_FEEDBACK("pending_feedback"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private InterviewValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

