/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * TaskStatusValue
 * 
 * <p>The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
 */
@JsonDeserialize(using = TaskStatusValue._Deserializer.class)
@JsonSerialize(using = TaskStatusValue._Serializer.class)
public class TaskStatusValue {

    public static final TaskStatusValue OPEN = new TaskStatusValue("open");
    public static final TaskStatusValue IN_PROGRESS = new TaskStatusValue("in_progress");
    public static final TaskStatusValue BLOCKED = new TaskStatusValue("blocked");
    public static final TaskStatusValue COMPLETED = new TaskStatusValue("completed");
    public static final TaskStatusValue CANCELLED = new TaskStatusValue("cancelled");
    public static final TaskStatusValue UNMAPPED_VALUE = new TaskStatusValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TaskStatusValue> values = createValuesMap();
    private static final Map<String, TaskStatusValueEnum> enums = createEnumsMap();

    private final String value;

    private TaskStatusValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TaskStatusValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TaskStatusValue
     */ 
    public static TaskStatusValue of(String value) {
        synchronized (TaskStatusValue.class) {
            return values.computeIfAbsent(value, v -> new TaskStatusValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<TaskStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TaskStatusValue other = (TaskStatusValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TaskStatusValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TaskStatusValue[] values() {
        synchronized (TaskStatusValue.class) {
            return values.values().toArray(new TaskStatusValue[] {});
        }
    }

    private static final Map<String, TaskStatusValue> createValuesMap() {
        Map<String, TaskStatusValue> map = new LinkedHashMap<>();
        map.put("open", OPEN);
        map.put("in_progress", IN_PROGRESS);
        map.put("blocked", BLOCKED);
        map.put("completed", COMPLETED);
        map.put("cancelled", CANCELLED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TaskStatusValueEnum> createEnumsMap() {
        Map<String, TaskStatusValueEnum> map = new HashMap<>();
        map.put("open", TaskStatusValueEnum.OPEN);
        map.put("in_progress", TaskStatusValueEnum.IN_PROGRESS);
        map.put("blocked", TaskStatusValueEnum.BLOCKED);
        map.put("completed", TaskStatusValueEnum.COMPLETED);
        map.put("cancelled", TaskStatusValueEnum.CANCELLED);
        map.put("unmapped_value", TaskStatusValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<TaskStatusValue> {

        protected _Serializer() {
            super(TaskStatusValue.class);
        }

        @Override
        public void serialize(TaskStatusValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<TaskStatusValue> {

        protected _Deserializer() {
            super(TaskStatusValue.class);
        }

        @Override
        public TaskStatusValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return TaskStatusValue.of(v);
        }
    }
    
    public enum TaskStatusValueEnum {

        OPEN("open"),
        IN_PROGRESS("in_progress"),
        BLOCKED("blocked"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TaskStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

