/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class ApplicationChangesValue {
    public static final ApplicationChangesValue APPLICATION_STATUS = new ApplicationChangesValue("application_status");
    public static final ApplicationChangesValue INTERVIEW_STAGE = new ApplicationChangesValue("interview_stage");
    public static final ApplicationChangesValue REJECTED_REASONS = new ApplicationChangesValue("rejected_reasons");
    public static final ApplicationChangesValue UNMAPPED_VALUE = new ApplicationChangesValue("unmapped_value");
    private static final Map<String, ApplicationChangesValue> values = ApplicationChangesValue.createValuesMap();
    private static final Map<String, ApplicationChangesValueEnum> enums = ApplicationChangesValue.createEnumsMap();
    private final String value;

    private ApplicationChangesValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationChangesValue of(String value) {
        Class<ApplicationChangesValue> clazz = ApplicationChangesValue.class;
        synchronized (ApplicationChangesValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ApplicationChangesValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<ApplicationChangesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationChangesValue other = (ApplicationChangesValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ApplicationChangesValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationChangesValue[] values() {
        Class<ApplicationChangesValue> clazz = ApplicationChangesValue.class;
        synchronized (ApplicationChangesValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ApplicationChangesValue[0]);
        }
    }

    private static final Map<String, ApplicationChangesValue> createValuesMap() {
        LinkedHashMap<String, ApplicationChangesValue> map = new LinkedHashMap<String, ApplicationChangesValue>();
        map.put("application_status", APPLICATION_STATUS);
        map.put("interview_stage", INTERVIEW_STAGE);
        map.put("rejected_reasons", REJECTED_REASONS);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ApplicationChangesValueEnum> createEnumsMap() {
        HashMap<String, ApplicationChangesValueEnum> map = new HashMap<String, ApplicationChangesValueEnum>();
        map.put("application_status", ApplicationChangesValueEnum.APPLICATION_STATUS);
        map.put("interview_stage", ApplicationChangesValueEnum.INTERVIEW_STAGE);
        map.put("rejected_reasons", ApplicationChangesValueEnum.REJECTED_REASONS);
        map.put("unmapped_value", ApplicationChangesValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ApplicationChangesValueEnum {
        APPLICATION_STATUS("application_status"),
        INTERVIEW_STAGE("interview_stage"),
        REJECTED_REASONS("rejected_reasons"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ApplicationChangesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<ApplicationChangesValue> {
        protected _Deserializer() {
            super(ApplicationChangesValue.class);
        }

        public ApplicationChangesValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return ApplicationChangesValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<ApplicationChangesValue> {
        protected _Serializer() {
            super(ApplicationChangesValue.class);
        }

        public void serialize(ApplicationChangesValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

