/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.InterviewPartSourceValue;
import com.stackone.stackone_client_java.models.components.InterviewPartValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class InterviewPartType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends InterviewPartValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends InterviewPartSourceValue> sourceValue;

    @JsonCreator
    public InterviewPartType(@JsonProperty(value="value") JsonNullable<? extends InterviewPartValue> value, @JsonProperty(value="source_value") JsonNullable<? extends InterviewPartSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public InterviewPartType() {
        this((JsonNullable<? extends InterviewPartValue>)JsonNullable.undefined(), (JsonNullable<? extends InterviewPartSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<InterviewPartValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<InterviewPartSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public InterviewPartType withValue(InterviewPartValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public InterviewPartType withValue(JsonNullable<? extends InterviewPartValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public InterviewPartType withSourceValue(InterviewPartSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public InterviewPartType withSourceValue(JsonNullable<? extends InterviewPartSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterviewPartType other = (InterviewPartType)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(InterviewPartType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends InterviewPartValue> value = JsonNullable.undefined();
        private JsonNullable<? extends InterviewPartSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(InterviewPartValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends InterviewPartValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(InterviewPartSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends InterviewPartSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public InterviewPartType build() {
            return new InterviewPartType(this.value, this.sourceValue);
        }
    }
}

