/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListGroupsRequest;
import com.stackone.stackone_client_java.models.operations.HrisListGroupsResponse;
import com.stackone.stackone_client_java.operations.HrisListGroupsOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListGroupsRequestBuilder {
    private HrisListGroupsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public HrisListGroupsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListGroupsRequestBuilder request(HrisListGroupsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListGroupsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListGroupsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListGroupsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListGroupsOperation operation = new HrisListGroupsOperation(this.sdkConfiguration, options);
        return (HrisListGroupsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<HrisListGroupsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListGroupsOperation operation = new HrisListGroupsOperation(this.sdkConfiguration, options);
        Paginator<HrisListGroupsRequest, String> iterator = new Paginator<HrisListGroupsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), HrisListGroupsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<HrisListGroupsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

