/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.LmsListUsersRequest;
import com.stackone.stackone_client_java.models.operations.LmsListUsersResponse;
import com.stackone.stackone_client_java.operations.LmsListUsersOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class LmsListUsersRequestBuilder {
    private LmsListUsersRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public LmsListUsersRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsListUsersRequestBuilder request(LmsListUsersRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsListUsersRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsListUsersRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public LmsListUsersResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListUsersOperation operation = new LmsListUsersOperation(this.sdkConfiguration, options);
        return (LmsListUsersResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<LmsListUsersResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListUsersOperation operation = new LmsListUsersOperation(this.sdkConfiguration, options);
        Paginator<LmsListUsersRequest, String> iterator = new Paginator<LmsListUsersRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), LmsListUsersRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<LmsListUsersResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

