/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.EventStreamLineReader;
import com.stackone.stackone_client_java.utils.EventStreamMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EventStreamReader
implements AutoCloseable {
    private static final int BUFFER_SIZE = 8192;
    private static final String BYTE_ORDER_MARK = "\ufeff";
    private final Reader reader;
    private boolean first = true;
    private static final Pattern LINE_PATTERN = Pattern.compile("^([a-zA-Z]+): ?(.*)$");
    private static final char LINEFEED = '\n';

    public EventStreamReader(InputStream in) {
        this.reader = new EventStreamLineReader(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8), 8192));
    }

    public String readRawMessage() throws IOException {
        StringBuilder line = new StringBuilder();
        StringBuilder b = new StringBuilder();
        char previousCh = '\u0000';
        boolean previousAvailable = false;
        boolean isComment = false;
        int v;
        while ((v = this.reader.read()) != -1) {
            char ch = (char)v;
            if (previousAvailable) {
                if (previousCh == '\n' && ch == '\n') {
                    b.append((CharSequence)line);
                    line.setLength(0);
                    isComment = false;
                    EventStreamReader.trimTrailingNewLines(b);
                    String msg = b.toString();
                    if (this.first) {
                        if (msg.startsWith(BYTE_ORDER_MARK)) {
                            msg = msg.substring(BYTE_ORDER_MARK.length());
                        }
                        this.first = false;
                    }
                    return msg;
                }
                if (line.length() == 0 && previousCh == ':') {
                    isComment = true;
                }
                if (!isComment) {
                    line.append(previousCh);
                    if (previousCh == '\n') {
                        b.append((CharSequence)line);
                        line.setLength(0);
                    }
                } else if (previousCh == '\n') {
                    isComment = false;
                }
            } else {
                previousAvailable = true;
            }
            previousCh = ch;
        }
        return null;
    }

    public Optional<EventStreamMessage> readMessage() throws IOException {
        String m = this.readRawMessage();
        if (m == null) {
            return Optional.empty();
        }
        return Optional.of(EventStreamReader.parseMessage(m));
    }

    public static EventStreamMessage parseMessage(String text) {
        String[] lines = text.split("\n");
        Optional<String> event = Optional.empty();
        Optional<String> id = Optional.empty();
        Optional<Integer> retryMs = Optional.empty();
        StringBuilder data = new StringBuilder();
        boolean firstData = true;
        for (String line : lines) {
            Matcher m = LINE_PATTERN.matcher(line);
            if (!m.find()) continue;
            String key = m.group(1).toLowerCase();
            String value = m.group(2);
            if ("event".equals(key)) {
                event = Optional.of(value);
                continue;
            }
            if ("id".equals(key)) {
                id = Optional.of(value);
                continue;
            }
            if ("retry".equals(key)) {
                try {
                    retryMs = Optional.of(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!"data".equals(key)) continue;
            if (!firstData) {
                data.append('\n');
            }
            firstData = false;
            data.append(value);
        }
        return new EventStreamMessage(event, id, retryMs, data.toString());
    }

    private static StringBuilder trimTrailingNewLines(StringBuilder b) {
        int i;
        for (i = 0; b.length() > i && b.charAt(b.length() - i - 1) == '\n'; ++i) {
        }
        b.setLength(b.length() - i);
        return b;
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }
}

