/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils.pagination;

import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.ProgressTrackerStrategy;

public class OffsetTracker<ProgressParamT extends Number>
implements ProgressTrackerStrategy<ProgressParamT> {
    private final String resultSizeExpression;
    private final long minItems;
    private final Class<ProgressParamT> offsetType;
    private long currentValue;

    public OffsetTracker(String resultSizeExpression, Class<ProgressParamT> offsetType, long initialOffset, long minItems) {
        this.resultSizeExpression = resultSizeExpression;
        this.minItems = minItems;
        this.offsetType = offsetType;
        this.currentValue = initialOffset;
    }

    @Override
    public boolean advance(ReadContext respJson) {
        Long numItems = (Long)respJson.read(this.resultSizeExpression, Long.class, new Predicate[0]);
        if (numItems == null) {
            numItems = 0L;
        }
        if (numItems < this.minItems) {
            return false;
        }
        this.currentValue += numItems.longValue();
        return true;
    }

    @Override
    public ProgressParamT getPosition() {
        return (ProgressParamT)((Number)Utils.castLong(this.currentValue, this.offsetType));
    }
}

