/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsCreateJobRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsCreateJobRequest;
import com.stackone.stackone_client_java.models.operations.AtsCreateJobResponse;
import com.stackone.stackone_client_java.operations.AtsCreateJobOperation;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsCreateJobRequestBuilder {
    private String xAccountId;
    private AtsCreateJobRequestDto atsCreateJobRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsCreateJobRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsCreateJobRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateJobRequestBuilder atsCreateJobRequestDto(AtsCreateJobRequestDto atsCreateJobRequestDto) {
        Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
        this.atsCreateJobRequestDto = atsCreateJobRequestDto;
        return this;
    }

    public AtsCreateJobRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsCreateJobRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AtsCreateJobRequest buildRequest() {
        AtsCreateJobRequest request = new AtsCreateJobRequest(this.xAccountId, this.atsCreateJobRequestDto);
        return request;
    }

    public AtsCreateJobResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsCreateJobOperation operation = new AtsCreateJobOperation(this.sdkConfiguration, options);
        AtsCreateJobRequest request = this.buildRequest();
        return (AtsCreateJobResponse)operation.handleResponse(operation.doRequest(request));
    }
}

