/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.SmsTemplateResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingGetSmsTemplateResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends SmsTemplateResult> smsTemplateResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingGetSmsTemplateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends SmsTemplateResult> smsTemplateResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.smsTemplateResult = smsTemplateResult;
        this.headers = headers;
    }

    public MarketingGetSmsTemplateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<SmsTemplateResult> smsTemplateResult() {
        return this.smsTemplateResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingGetSmsTemplateResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingGetSmsTemplateResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingGetSmsTemplateResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingGetSmsTemplateResponse withSmsTemplateResult(SmsTemplateResult smsTemplateResult) {
        Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
        this.smsTemplateResult = Optional.ofNullable(smsTemplateResult);
        return this;
    }

    public MarketingGetSmsTemplateResponse withSmsTemplateResult(Optional<? extends SmsTemplateResult> smsTemplateResult) {
        Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
        this.smsTemplateResult = smsTemplateResult;
        return this;
    }

    public MarketingGetSmsTemplateResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingGetSmsTemplateResponse other = (MarketingGetSmsTemplateResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.smsTemplateResult, other.smsTemplateResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.smsTemplateResult, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingGetSmsTemplateResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "smsTemplateResult", this.smsTemplateResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends SmsTemplateResult> smsTemplateResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder smsTemplateResult(SmsTemplateResult smsTemplateResult) {
            Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
            this.smsTemplateResult = Optional.ofNullable(smsTemplateResult);
            return this;
        }

        public Builder smsTemplateResult(Optional<? extends SmsTemplateResult> smsTemplateResult) {
            Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
            this.smsTemplateResult = smsTemplateResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingGetSmsTemplateResponse build() {
            return new MarketingGetSmsTemplateResponse(this.contentType, this.statusCode, this.rawResponse, this.smsTemplateResult, this.headers);
        }
    }
}

