/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.http;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class HttpConnection {
    private OkHttpClient client = new OkHttpClient();

    public HttpConnection(Integer connTimeout, Integer readTimeout, Integer writeTimeout) {
        this.client.setConnectTimeout((long)connTimeout.intValue(), TimeUnit.SECONDS);
        this.client.setReadTimeout((long)readTimeout.intValue(), TimeUnit.SECONDS);
        this.client.setWriteTimeout((long)writeTimeout.intValue(), TimeUnit.SECONDS);
    }

    public Response doRequest(Request request) throws TencentCloudSDKException {
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
        }
        catch (IOException e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        return response;
    }

    public Response getRequest(String url) throws TencentCloudSDKException {
        Request request = null;
        try {
            request = new Request.Builder().url(url).get().build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String url, String body) throws TencentCloudSDKException {
        MediaType contentType = MediaType.parse((String)"application/x-www-form-urlencoded");
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create((MediaType)contentType, (String)body)).build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        return this.doRequest(request);
    }
}

