/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class SyncAssetScanRequest extends AbstractModel{

    /**
    * 是否同步
    */
    @SerializedName("Sync")
    @Expose
    private Boolean Sync;

    /**
     * Get 是否同步 
     * @return Sync 是否同步
     */
    public Boolean getSync() {
        return this.Sync;
    }

    /**
     * Set 是否同步
     * @param Sync 是否同步
     */
    public void setSync(Boolean Sync) {
        this.Sync = Sync;
    }

    public SyncAssetScanRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public SyncAssetScanRequest(SyncAssetScanRequest source) {
        if (source.Sync != null) {
            this.Sync = new Boolean(source.Sync);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Sync", this.Sync);

    }
}

