/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.faceid.v20180301.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CheckBankCardInformationRequest extends AbstractModel{

    /**
    * 银行卡号。
    */
    @SerializedName("BankCard")
    @Expose
    private String BankCard;

    /**
     * Get 银行卡号。 
     * @return BankCard 银行卡号。
     */
    public String getBankCard() {
        return this.BankCard;
    }

    /**
     * Set 银行卡号。
     * @param BankCard 银行卡号。
     */
    public void setBankCard(String BankCard) {
        this.BankCard = BankCard;
    }

    public CheckBankCardInformationRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CheckBankCardInformationRequest(CheckBankCardInformationRequest source) {
        if (source.BankCard != null) {
            this.BankCard = new String(source.BankCard);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "BankCard", this.BankCard);

    }
}

