/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tms.v20201229.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class TextModerationRequest extends AbstractModel{

    /**
    * 该字段表示待检测文本内容的Base64编码，文本原文长度不能超过**15000字节**或**5000个汉字** （以先达到者为准）；若超出长度限制，接口将会报错。<br>备注：目前仅支持中文、英文、数字的检测与审核。
    */
    @SerializedName("Content")
    @Expose
    private String Content;

    /**
    * 该字段表示策略的具体编号，用于接口调度，在内容安全控制台中可配置。若不传入Biztype参数（留空），则代表采用默认的识别策略；传入则会在审核时根据业务场景采取不同的审核策略。<br>备注：Biztype仅为数字、字母与下划线的组合，长度为3-32个字符；不同Biztype关联不同的业务场景与识别能力策略，调用前请确认正确的Biztype。
    */
    @SerializedName("BizType")
    @Expose
    private String BizType;

    /**
    * 该字段表示您为待检测对象分配的数据ID，传入后可方便您对文件进行标识和管理。<br>取值：由英文字母（大小写均可）、数字及四个特殊符号（_，-，@，#）组成，**长度不超过64个字符**。
    */
    @SerializedName("DataId")
    @Expose
    private String DataId;

    /**
    * 该字段表示待检测对象对应的用户相关信息，传入后可便于甄别相应违规风险用户。
    */
    @SerializedName("User")
    @Expose
    private User User;

    /**
    * 该字段表示待检测对象对应的设备相关信息，传入后可便于甄别相应违规风险设备。
    */
    @SerializedName("Device")
    @Expose
    private Device Device;

    /**
     * Get 该字段表示待检测文本内容的Base64编码，文本原文长度不能超过**15000字节**或**5000个汉字** （以先达到者为准）；若超出长度限制，接口将会报错。<br>备注：目前仅支持中文、英文、数字的检测与审核。 
     * @return Content 该字段表示待检测文本内容的Base64编码，文本原文长度不能超过**15000字节**或**5000个汉字** （以先达到者为准）；若超出长度限制，接口将会报错。<br>备注：目前仅支持中文、英文、数字的检测与审核。
     */
    public String getContent() {
        return this.Content;
    }

    /**
     * Set 该字段表示待检测文本内容的Base64编码，文本原文长度不能超过**15000字节**或**5000个汉字** （以先达到者为准）；若超出长度限制，接口将会报错。<br>备注：目前仅支持中文、英文、数字的检测与审核。
     * @param Content 该字段表示待检测文本内容的Base64编码，文本原文长度不能超过**15000字节**或**5000个汉字** （以先达到者为准）；若超出长度限制，接口将会报错。<br>备注：目前仅支持中文、英文、数字的检测与审核。
     */
    public void setContent(String Content) {
        this.Content = Content;
    }

    /**
     * Get 该字段表示策略的具体编号，用于接口调度，在内容安全控制台中可配置。若不传入Biztype参数（留空），则代表采用默认的识别策略；传入则会在审核时根据业务场景采取不同的审核策略。<br>备注：Biztype仅为数字、字母与下划线的组合，长度为3-32个字符；不同Biztype关联不同的业务场景与识别能力策略，调用前请确认正确的Biztype。 
     * @return BizType 该字段表示策略的具体编号，用于接口调度，在内容安全控制台中可配置。若不传入Biztype参数（留空），则代表采用默认的识别策略；传入则会在审核时根据业务场景采取不同的审核策略。<br>备注：Biztype仅为数字、字母与下划线的组合，长度为3-32个字符；不同Biztype关联不同的业务场景与识别能力策略，调用前请确认正确的Biztype。
     */
    public String getBizType() {
        return this.BizType;
    }

    /**
     * Set 该字段表示策略的具体编号，用于接口调度，在内容安全控制台中可配置。若不传入Biztype参数（留空），则代表采用默认的识别策略；传入则会在审核时根据业务场景采取不同的审核策略。<br>备注：Biztype仅为数字、字母与下划线的组合，长度为3-32个字符；不同Biztype关联不同的业务场景与识别能力策略，调用前请确认正确的Biztype。
     * @param BizType 该字段表示策略的具体编号，用于接口调度，在内容安全控制台中可配置。若不传入Biztype参数（留空），则代表采用默认的识别策略；传入则会在审核时根据业务场景采取不同的审核策略。<br>备注：Biztype仅为数字、字母与下划线的组合，长度为3-32个字符；不同Biztype关联不同的业务场景与识别能力策略，调用前请确认正确的Biztype。
     */
    public void setBizType(String BizType) {
        this.BizType = BizType;
    }

    /**
     * Get 该字段表示您为待检测对象分配的数据ID，传入后可方便您对文件进行标识和管理。<br>取值：由英文字母（大小写均可）、数字及四个特殊符号（_，-，@，#）组成，**长度不超过64个字符**。 
     * @return DataId 该字段表示您为待检测对象分配的数据ID，传入后可方便您对文件进行标识和管理。<br>取值：由英文字母（大小写均可）、数字及四个特殊符号（_，-，@，#）组成，**长度不超过64个字符**。
     */
    public String getDataId() {
        return this.DataId;
    }

    /**
     * Set 该字段表示您为待检测对象分配的数据ID，传入后可方便您对文件进行标识和管理。<br>取值：由英文字母（大小写均可）、数字及四个特殊符号（_，-，@，#）组成，**长度不超过64个字符**。
     * @param DataId 该字段表示您为待检测对象分配的数据ID，传入后可方便您对文件进行标识和管理。<br>取值：由英文字母（大小写均可）、数字及四个特殊符号（_，-，@，#）组成，**长度不超过64个字符**。
     */
    public void setDataId(String DataId) {
        this.DataId = DataId;
    }

    /**
     * Get 该字段表示待检测对象对应的用户相关信息，传入后可便于甄别相应违规风险用户。 
     * @return User 该字段表示待检测对象对应的用户相关信息，传入后可便于甄别相应违规风险用户。
     */
    public User getUser() {
        return this.User;
    }

    /**
     * Set 该字段表示待检测对象对应的用户相关信息，传入后可便于甄别相应违规风险用户。
     * @param User 该字段表示待检测对象对应的用户相关信息，传入后可便于甄别相应违规风险用户。
     */
    public void setUser(User User) {
        this.User = User;
    }

    /**
     * Get 该字段表示待检测对象对应的设备相关信息，传入后可便于甄别相应违规风险设备。 
     * @return Device 该字段表示待检测对象对应的设备相关信息，传入后可便于甄别相应违规风险设备。
     */
    public Device getDevice() {
        return this.Device;
    }

    /**
     * Set 该字段表示待检测对象对应的设备相关信息，传入后可便于甄别相应违规风险设备。
     * @param Device 该字段表示待检测对象对应的设备相关信息，传入后可便于甄别相应违规风险设备。
     */
    public void setDevice(Device Device) {
        this.Device = Device;
    }

    public TextModerationRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public TextModerationRequest(TextModerationRequest source) {
        if (source.Content != null) {
            this.Content = new String(source.Content);
        }
        if (source.BizType != null) {
            this.BizType = new String(source.BizType);
        }
        if (source.DataId != null) {
            this.DataId = new String(source.DataId);
        }
        if (source.User != null) {
            this.User = new User(source.User);
        }
        if (source.Device != null) {
            this.Device = new Device(source.Device);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Content", this.Content);
        this.setParamSimple(map, prefix + "BizType", this.BizType);
        this.setParamSimple(map, prefix + "DataId", this.DataId);
        this.setParamObj(map, prefix + "User.", this.User);
        this.setParamObj(map, prefix + "Device.", this.Device);

    }
}

