/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bsca.v20210811.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ComponentVulnerabilitySummary extends AbstractModel{

    /**
    * 用于匹配漏洞的PURL
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("PURL")
    @Expose
    private PURL PURL;

    /**
    * 该组件是否包含修复漏洞的官方补丁
    */
    @SerializedName("CanBeFixed")
    @Expose
    private Boolean CanBeFixed;

    /**
    * 修复漏洞的组件版本号
    */
    @SerializedName("FixedVersion")
    @Expose
    private String FixedVersion;

    /**
    * 漏洞影响的组件版本号
    */
    @SerializedName("AffectedVersion")
    @Expose
    private String AffectedVersion;

    /**
    * 漏洞影响组件
    */
    @SerializedName("AffectedComponent")
    @Expose
    private String AffectedComponent;

    /**
    * 漏洞在该产品中的风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
    */
    @SerializedName("RiskLevel")
    @Expose
    private String RiskLevel;

    /**
     * Get 用于匹配漏洞的PURL
注意：此字段可能返回 null，表示取不到有效值。 
     * @return PURL 用于匹配漏洞的PURL
注意：此字段可能返回 null，表示取不到有效值。
     */
    public PURL getPURL() {
        return this.PURL;
    }

    /**
     * Set 用于匹配漏洞的PURL
注意：此字段可能返回 null，表示取不到有效值。
     * @param PURL 用于匹配漏洞的PURL
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setPURL(PURL PURL) {
        this.PURL = PURL;
    }

    /**
     * Get 该组件是否包含修复漏洞的官方补丁 
     * @return CanBeFixed 该组件是否包含修复漏洞的官方补丁
     */
    public Boolean getCanBeFixed() {
        return this.CanBeFixed;
    }

    /**
     * Set 该组件是否包含修复漏洞的官方补丁
     * @param CanBeFixed 该组件是否包含修复漏洞的官方补丁
     */
    public void setCanBeFixed(Boolean CanBeFixed) {
        this.CanBeFixed = CanBeFixed;
    }

    /**
     * Get 修复漏洞的组件版本号 
     * @return FixedVersion 修复漏洞的组件版本号
     */
    public String getFixedVersion() {
        return this.FixedVersion;
    }

    /**
     * Set 修复漏洞的组件版本号
     * @param FixedVersion 修复漏洞的组件版本号
     */
    public void setFixedVersion(String FixedVersion) {
        this.FixedVersion = FixedVersion;
    }

    /**
     * Get 漏洞影响的组件版本号 
     * @return AffectedVersion 漏洞影响的组件版本号
     */
    public String getAffectedVersion() {
        return this.AffectedVersion;
    }

    /**
     * Set 漏洞影响的组件版本号
     * @param AffectedVersion 漏洞影响的组件版本号
     */
    public void setAffectedVersion(String AffectedVersion) {
        this.AffectedVersion = AffectedVersion;
    }

    /**
     * Get 漏洞影响组件 
     * @return AffectedComponent 漏洞影响组件
     */
    public String getAffectedComponent() {
        return this.AffectedComponent;
    }

    /**
     * Set 漏洞影响组件
     * @param AffectedComponent 漏洞影响组件
     */
    public void setAffectedComponent(String AffectedComponent) {
        this.AffectedComponent = AffectedComponent;
    }

    /**
     * Get 漏洞在该产品中的风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li> 
     * @return RiskLevel 漏洞在该产品中的风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     */
    public String getRiskLevel() {
        return this.RiskLevel;
    }

    /**
     * Set 漏洞在该产品中的风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     * @param RiskLevel 漏洞在该产品中的风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     */
    public void setRiskLevel(String RiskLevel) {
        this.RiskLevel = RiskLevel;
    }

    public ComponentVulnerabilitySummary() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ComponentVulnerabilitySummary(ComponentVulnerabilitySummary source) {
        if (source.PURL != null) {
            this.PURL = new PURL(source.PURL);
        }
        if (source.CanBeFixed != null) {
            this.CanBeFixed = new Boolean(source.CanBeFixed);
        }
        if (source.FixedVersion != null) {
            this.FixedVersion = new String(source.FixedVersion);
        }
        if (source.AffectedVersion != null) {
            this.AffectedVersion = new String(source.AffectedVersion);
        }
        if (source.AffectedComponent != null) {
            this.AffectedComponent = new String(source.AffectedComponent);
        }
        if (source.RiskLevel != null) {
            this.RiskLevel = new String(source.RiskLevel);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "PURL.", this.PURL);
        this.setParamSimple(map, prefix + "CanBeFixed", this.CanBeFixed);
        this.setParamSimple(map, prefix + "FixedVersion", this.FixedVersion);
        this.setParamSimple(map, prefix + "AffectedVersion", this.AffectedVersion);
        this.setParamSimple(map, prefix + "AffectedComponent", this.AffectedComponent);
        this.setParamSimple(map, prefix + "RiskLevel", this.RiskLevel);

    }
}

