/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bsca.v20210811.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeKBVulnerabilityRequest extends AbstractModel{

    /**
    * CVE ID列表（不能与Vul ID同时存在）
    */
    @SerializedName("CVEID")
    @Expose
    private String [] CVEID;

    /**
    * Vul ID列表（不能与CVE ID 同时存在）
    */
    @SerializedName("VulID")
    @Expose
    private String [] VulID;

    /**
     * Get CVE ID列表（不能与Vul ID同时存在） 
     * @return CVEID CVE ID列表（不能与Vul ID同时存在）
     */
    public String [] getCVEID() {
        return this.CVEID;
    }

    /**
     * Set CVE ID列表（不能与Vul ID同时存在）
     * @param CVEID CVE ID列表（不能与Vul ID同时存在）
     */
    public void setCVEID(String [] CVEID) {
        this.CVEID = CVEID;
    }

    /**
     * Get Vul ID列表（不能与CVE ID 同时存在） 
     * @return VulID Vul ID列表（不能与CVE ID 同时存在）
     */
    public String [] getVulID() {
        return this.VulID;
    }

    /**
     * Set Vul ID列表（不能与CVE ID 同时存在）
     * @param VulID Vul ID列表（不能与CVE ID 同时存在）
     */
    public void setVulID(String [] VulID) {
        this.VulID = VulID;
    }

    public DescribeKBVulnerabilityRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeKBVulnerabilityRequest(DescribeKBVulnerabilityRequest source) {
        if (source.CVEID != null) {
            this.CVEID = new String[source.CVEID.length];
            for (int i = 0; i < source.CVEID.length; i++) {
                this.CVEID[i] = new String(source.CVEID[i]);
            }
        }
        if (source.VulID != null) {
            this.VulID = new String[source.VulID.length];
            for (int i = 0; i < source.VulID.length; i++) {
                this.VulID[i] = new String(source.VulID[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "CVEID.", this.CVEID);
        this.setParamArraySimple(map, prefix + "VulID.", this.VulID);

    }
}

