/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.teo.v20220106.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ModifyDnssecRequest extends AbstractModel{

    /**
    * 站点 ID
    */
    @SerializedName("Id")
    @Expose
    private String Id;

    /**
    * DNSSEC 状态
- enabled 开启
- disabled 关闭
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
     * Get 站点 ID 
     * @return Id 站点 ID
     */
    public String getId() {
        return this.Id;
    }

    /**
     * Set 站点 ID
     * @param Id 站点 ID
     */
    public void setId(String Id) {
        this.Id = Id;
    }

    /**
     * Get DNSSEC 状态
- enabled 开启
- disabled 关闭 
     * @return Status DNSSEC 状态
- enabled 开启
- disabled 关闭
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set DNSSEC 状态
- enabled 开启
- disabled 关闭
     * @param Status DNSSEC 状态
- enabled 开启
- disabled 关闭
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    public ModifyDnssecRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ModifyDnssecRequest(ModifyDnssecRequest source) {
        if (source.Id != null) {
            this.Id = new String(source.Id);
        }
        if (source.Status != null) {
            this.Status = new String(source.Status);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "Status", this.Status);

    }
}

