/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.netty;

import com.weicoder.socket.Client;
import com.weicoder.socket.Session;
import com.weicoder.socket.netty.NettyHandler;
import com.weicoder.socket.netty.NettySession;
import com.weicoder.socket.params.SocketParams;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;

public final class NettyClient
implements Client {
    private Bootstrap bootstrap = new Bootstrap();
    private ChannelFuture future;
    private NettyHandler handler;
    private Session session;

    public NettyClient(String name) {
        this.handler = new NettyHandler(name);
        this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)false);
        this.bootstrap.option(ChannelOption.SO_LINGER, (Object)0);
        this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)32768);
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)8192);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.handler((ChannelHandler)this.handler);
        this.bootstrap.remoteAddress(SocketParams.getHost(name), SocketParams.getPort(name));
    }

    @Override
    public void connect() {
        this.future = this.bootstrap.connect().awaitUninterruptibly();
        this.session = new NettySession("client", this.future.channel());
    }

    @Override
    public Session session() {
        if (this.session == null) {
            this.connect();
        }
        return this.session;
    }
}

