/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.netty;

import com.weicoder.common.log.Logs;
import com.weicoder.socket.Session;
import com.weicoder.socket.netty.NettySession;
import com.weicoder.socket.process.Process;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;

@ChannelHandler.Sharable
public final class NettyHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private String name;
    private Process process;
    private AttributeKey<Session> sessionKey;

    public NettyHandler(String name) {
        this.name = name;
        this.process = new Process(name);
        this.sessionKey = AttributeKey.valueOf((String)"session");
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Session s = this.getSesson(ctx.channel());
        if (s == null) {
            Logs.debug((String)"channel session is null = {}", (Object[])new Object[]{ctx});
        } else {
            Logs.debug((String)"channel is inactive = {}", (Object[])new Object[]{ctx});
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        NettySession s = null;
        s = new NettySession(this.name, ctx.channel());
        ctx.channel().attr(this.sessionKey).set((Object)s);
        this.process.connected(s);
        Logs.debug((String)"channel is active = {}", (Object[])new Object[]{ctx});
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Logs.error((Throwable)cause);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] data = new byte[msg.readableBytes()];
        msg.readBytes(data);
        Logs.trace((String)"channel read data len={} channel={}", (Object[])new Object[]{data.length, ctx});
        this.process.process(this.getSesson(ctx.channel()), data);
    }

    private Session getSesson(Channel channel) {
        Session s = (Session)channel.attr(this.sessionKey).get();
        if (s == null) {
            Logs.warn((String)"channel to session is null channel", (Object[])new Object[]{channel});
            channel.close();
            channel.disconnect();
        }
        return s;
    }
}

