/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.netty;

import com.weicoder.common.lang.Bytes;
import com.weicoder.common.util.IpUtil;
import com.weicoder.socket.Session;
import com.weicoder.socket.base.BaseSession;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;

public final class NettySession
extends BaseSession
implements Session {
    private Channel channel;

    public NettySession(String name, Channel channel) {
        super(name);
        this.address(channel.remoteAddress());
        this.id = Bytes.toLong((byte[])Bytes.toBytes((Object[])new Object[]{IpUtil.encode((String)this.ip), this.port}));
        this.channel = channel;
    }

    @Override
    public void write(byte[] data) {
        this.channel.write((Object)PooledByteBufAllocator.DEFAULT.buffer().writeBytes(data));
    }

    @Override
    public void close() {
        this.channel.flush();
        this.channel.close();
        this.channel.disconnect();
        this.channel = null;
    }

    @Override
    public void flush() {
        this.channel.flush();
    }
}

