/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.params;

import com.weicoder.common.config.Config;
import com.weicoder.common.config.ConfigFactory;
import com.weicoder.common.params.Params;

public final class SocketParams {
    public static final Config CONFIG = ConfigFactory.getConfig((String)"socket");
    public static final int TIME = CONFIG.getInt("time", 10);
    public static final int TIMEOUT = CONFIG.getInt("timeout", 60);
    public static final Boolean ZIP = CONFIG.getBoolean("zip", false);

    public static String getHost(String name) {
        return CONFIG.getString(SocketParams.getKey(name, "host"));
    }

    public static int getPort(String name) {
        return CONFIG.getInt(SocketParams.getKey(name, "port"));
    }

    public static boolean isZip(String name) {
        return CONFIG.getBoolean(SocketParams.getKey(name, "zip"), false);
    }

    public static String getConnected(String name) {
        return CONFIG.getString(SocketParams.getKey(name, "connected"));
    }

    public static String getClosed(String name) {
        return CONFIG.getString(SocketParams.getKey(name, "closed"));
    }

    private static String getKey(String name, String key) {
        return Params.getKey((String)"", (String)name, (String)key);
    }

    private SocketParams() {
    }
}

